package org.nakedobjects.nof.testsystem;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.StaticContext;
import org.nakedobjects.testing.TestConfiguration;
import org.nakedobjects.testing.TestSession;


//TODO combine with all versions of TestSystem
public class TestProxySystem {
    private int nextId = 1;
    private TestConfiguration configuration;
    private NakedObjectsContext nakedObjects;
    private final TestProxyObjectLoader objectLoader;
    private NakedObjectPersistor persistor;
    private final TestProxyReflector reflector;

    public TestProxySystem() {
        reflector = new TestProxyReflector();
        objectLoader = new TestProxyObjectLoader();
        persistor = new TestProxyPersistor();
        configuration = new TestConfiguration();
    }

    /*
     * public void addAdapterToObjectLoader(final Object object, final NakedObject adapter) {
     * objectLoader.addAdapter(object, adapter); }
     * 
     * public void addCollectionToObjectLoader(final NakedCollection collection) {
     * objectLoader.addAdapter(collection.getObject(), collection); }
     * 
     * public void addConfigurationProperty(String name, String value) { configuration.add(name, value); }
     * 
     * public void addIdentityToObjectLoader(final Oid oid, final NakedReference adapter) {
     * objectLoader.addIdentity(oid, adapter); }
     * 
     * public void addRecreatedAdapterToObjectLoader(final Oid oid, final DummyNakedObject adapter) {
     * objectLoader.addRecreated(oid, adapter); }
     * 
     * public void addRecreatedTransientToObjectLoader(final DummyNakedObject adapter) {
     * objectLoader.addRecreatedTransient(adapter); }
     * 
     * public void addValueToObjectLoader(final Object object, final NakedValue adapter) {
     * objectLoader.addAdapter(object, adapter);
     *  }
     */
    public NakedObject createAdapterForTransient(final Object associate) {
        NakedObject createAdapterForTransient = objectLoader.createAdapterForTransient(associate, false);
        objectLoader.addAdapter(associate, createAdapterForTransient);
        return createAdapterForTransient;
    }

    public void init() {
        nakedObjects = StaticContext.createInstance();

        NakedObjectsContext.setConfiguration(configuration);
        nakedObjects.setReflector(reflector);
        nakedObjects.setObjectLoader(objectLoader);
        nakedObjects.setObjectPersistor(persistor);
        nakedObjects.setSession(new TestSession());

        NakedObjectsContext.getReflector().init();
        NakedObjectsContext.getObjectLoader().init();
        NakedObjectsContext.getObjectPersistor().init();
    }

    public void shutdown() {
        NakedObjectsContext.getReflector().shutdown();
        NakedObjectsContext.getObjectLoader().shutdown();
        NakedObjectsContext.getObjectPersistor().shutdown();
    }

    public void resetLoader() {
        NakedObjectsContext.getObjectLoader().reset();
    }

    public TestProxyNakedObject createPersistentTestObject() {
        TestPojo pojo = new TestPojo();
        return createPersistentTestObject(pojo);
    }

    public TestProxyNakedObject createPersistentTestObject(TestPojo pojo) {
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupObject(pojo);
        
        Oid oid = persistor.createTransientOid(pojo);
        persistor.convertTransientToPersistentOid(oid);
        adapter.setupOid(oid);
        
        adapter.setupResolveState(ResolveState.TRANSIENT);

        
        setUpSpecification(pojo, adapter);
        addAdapterToLoader(pojo, adapter);

        persistor.makePersistent(adapter);
        
        return adapter;
    }

    private void setUpSpecification(TestPojo pojo, TestProxyNakedObject adapter) {
        adapter.setupSpecification(reflector.loadSpecification(pojo.getClass()));
    }

    private void addAdapterToLoader(TestPojo pojo, NakedObject adapter) {
        objectLoader.addAdapter(pojo, adapter);
        objectLoader.addIdentity(adapter.getOid(), adapter);
    }

    public TestProxyNakedObject createTransientTestObject() {
        TestPojo pojo = new TestPojo();
        return createTransientTestObject(pojo);
    }

    public TestProxyNakedObject createTransientTestObject(TestPojo pojo) {
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupOid(new TestProxyOid(nextId++, false));
        adapter.setupVersion(null);
        adapter.setupResolveState(ResolveState.TRANSIENT);
        adapter.setupObject(pojo);
        setUpSpecification(pojo, adapter);
        addAdapterToLoader(pojo, adapter);
        return adapter;
    }

    public TestProxySpecification getSpecification(Class cls) {
        return (TestProxySpecification) reflector.loadSpecification(cls);
    }

    public void setObjectPersistor(final NakedObjectPersistor persistor) {
        this.persistor = persistor;
    }
}
// Copyright (c) Naked Objects Group Ltd.
