package org.nakedobjects.nof.testsystem.tests;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyException;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySystem;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


public class CreateTransientObjectsTest extends TestCase {

    private TestProxySystem system;
    private TestProxyNakedObject adapter;
    private TestPojo pojo;
    private Oid oid;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        system = new TestProxySystem();
        system.init();

        pojo = new TestPojo();
        adapter = system.createTransientTestObject(pojo);
        oid = adapter.getOid();
    }

    public void testSpecification() {
        assertNotNull(adapter.getSpecification());
        assertNotNull(TestPojo.class.getName(), adapter.getSpecification().getFullName());
    }

    public void testStateOfCreatedAdapted() {
        assertNotNull(adapter);
        assertEquals(new TestProxyOid(1, false), oid);
        assertNull(adapter.getVersion());
        assertEquals(ResolveState.TRANSIENT, adapter.getResolveState());
        assertEquals(pojo, adapter.getObject());
    }

    public void test2ndPersistentCreationHasDifferentOid() {
        TestPojo pojo = new TestPojo();
        TestProxyNakedObject adapter2 = system.createTransientTestObject(pojo);

        assertNotNull(adapter2);
        assertEquals(new TestProxyOid(2, false), adapter2.getOid());
    }

    public void testIsAddedToObjectLoader() {
        NakedObject a = NakedObjectsContext.getObjectLoader().getAdapterFor(oid);
        assertEquals(adapter, a);
    }

    public void testAddedToPersistor() {
        system.resetLoader();
        try {
            NakedObjectsContext.getObjectPersistor().getObject(oid, null);
            fail();
        } catch (TestProxyException expected) {}
    }
}

// Copyright (c) Naked Objects Group Ltd.
