package org.nakedobjects.testing;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.persist.ConcurrencyException;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectActionInstance;
import org.nakedobjects.noa.reflect.NakedObjectActionInstanceImpl;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.reflect.OneToManyAssociationInstance;
import org.nakedobjects.noa.reflect.OneToManyAssociationInstanceImpl;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.reflect.OneToOneAssociationInstance;
import org.nakedobjects.noa.reflect.OneToOneAssociationInstanceImpl;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.reflect.ValueAssociationInstance;
import org.nakedobjects.noa.reflect.ValueAssociationInstanceImpl;
import org.nakedobjects.noa.reflect.listeners.ObjectListener;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.ToString;


public class DummyNakedObject implements NakedObject {
    private Hashtable fieldContents = new Hashtable();
    private Object object;
    private Oid oid;
    private NakedObjectSpecification spec;
    private ResolveState state;
    private String titleString;
    private Version version;
    private static int next;
    private final int id = next++;
    private String iconName;
	private Persistable persistable = Persistable.USER_PERSISTABLE;

    public DummyNakedObject() {
        super();
    }

    public DummyNakedObject(Object object) {
        this.object = object;
    }

    public DummyNakedObject(Oid oid) {
        this.oid = oid;
    }

    public DummyNakedObject(Oid oid, Version version) {
        this.oid = oid;
        this.version = version;
    }

    public DummyNakedObject(ResolveState state) {
        this.state = state;
    }

    public DummyNakedObject(Object object, ResolveState state) {
        this.object = object;
        this.state = state;
    }
    
    public DummyNakedObject(final String title) {
        this.titleString = title;
    }

    public DummyNakedObject(final Oid oid, final ResolveState state, final String title) {
        this.oid = oid;
        this.state = state;
        this.titleString = title;
    }

    public DummyNakedObject(final Oid oid, final ResolveState state) {
        this.oid = oid;
        this.state = state;
    }

    public void checkLock(final Version version) {
        if(this.version.different(version)) {
            throw new ConcurrencyException("", getOid());
        }
    }

    public Naked getField(final NakedObjectField field) {
        return (Naked) fieldContents.get(field.getId());
    }

    public String getIconName() {
        return iconName;
    }

    public Object getObject() {
        return object;
    }

    public Oid getOid() {
        return oid;
    }

    public ResolveState getResolveState() {
        return state;
    }

    public NakedObjectSpecification getSpecification() {
        return spec;
    }

    public Version getVersion() {
        return version;
    }

    public Persistable persistable() {
        return persistable;
    }

    public void setOptimisticLock(final Version version) {
        this.version = version;
    }

    public void setupFieldValue(final String name, final Naked field) {
        this.fieldContents.put(name, field);
    }
    
    public void setupIconName(String iconName) {
        this.iconName = iconName;
    }

    public void setupObject(final Object object) {
        this.object = object;
    }
    
    public void setupOid(final Oid oid) {
        this.oid = oid;
    }

    public void setupResolveState(final ResolveState state) {
        this.state = state;
    }

    public void setupSpecification(final NakedObjectSpecification spec) {
        this.spec = spec;
    }

    public void setupTitleString(final String titleString) {
        this.titleString = titleString;
    }

    public void setupVersion(final Version version) {
        this.version = version;
    }

    public void setValue(final OneToOneAssociation field, final Object object) {}

    public String titleString() {
        return titleString;
    }

    public String toString() {
        ToString str = new ToString(this, id);
        str.append("title", titleString);
        str.append("oid", oid);
        str.append("pojo", object);
        return str.toString();
    }

    public void changeState(final ResolveState state) {
        this.state.isValidToChangeTo(state);
        this.state = state;
    }

	public void setupPersistable(Persistable persistable) {
		this.persistable = persistable;
	}

    
    private Map actionInstancesByType = new HashMap();
    public NakedObjectActionInstance[] getActionInstances(NakedObjectAction.Type type) {
        NakedObjectActionInstance[] actionInstances = 
            (NakedObjectActionInstance[]) actionInstancesByType.get(type);
        if (actionInstances == null) {
            NakedObjectAction[] objectActions = getSpecification().getObjectActions(type);
            actionInstances = new NakedObjectActionInstance[objectActions.length];
            for(int i=0; i<objectActions.length; i++) {
                actionInstances[i] = new NakedObjectActionInstanceImpl(this, objectActions[i]);
            }
            actionInstancesByType.put(type, actionInstances);
        }
        return actionInstances;
    }
    
    // TODO: use a Hashtable instead
    public NakedObjectActionInstance getActionInstance(
            NakedObjectAction action) {
        NakedObjectActionInstance[] actionInstances = getActionInstances(action.getType());
        for(int i=0; i<actionInstances.length; i++) {
            if (actionInstances[i].getNakedObjectAction() == action) {
                return actionInstances[i];
            }
        }
        return null;
    }

    private OneToManyAssociationInstance[] oneToManyAssociationInstances;
    public OneToManyAssociationInstance[] getOneToManyAssociationInstances() {
        if (oneToManyAssociationInstances == null) {
            NakedObjectField[] fields = getSpecification().getFields(NakedObjectField.COLLECTIONS);
            oneToManyAssociationInstances = new OneToManyAssociationInstance[fields.length];
            for(int i=0; i<fields.length; i++) {
                oneToManyAssociationInstances[i] = 
                    new OneToManyAssociationInstanceImpl(this, (OneToManyAssociation) fields[i]);
            }
        }
        return oneToManyAssociationInstances;
    }
    // TODO: use a Hashtable instead
    public OneToManyAssociationInstance getOneToManyAssociation(
            OneToManyAssociation field) {
        OneToManyAssociationInstance[] oneToManyAssociationInstances = getOneToManyAssociationInstances();
        for(int i=0; i<oneToManyAssociationInstances.length; i++) {
            if (oneToManyAssociationInstances[i].getOneToManyAssociation() == field) {
                return oneToManyAssociationInstances[i];
            }
        }
        return null;
    }


    private OneToOneAssociationInstance[] oneToOneAssociationInstances;
    public OneToOneAssociationInstance[] getOneToOneAssociationInstances() {
        if (oneToOneAssociationInstances == null) {
            NakedObjectField[] fields = getSpecification().getFields(NakedObjectField.REFERENCES);
            oneToOneAssociationInstances = new OneToOneAssociationInstance[fields.length];
            for(int i=0; i<fields.length; i++) {
                oneToOneAssociationInstances[i] = 
                    new OneToOneAssociationInstanceImpl(this, (OneToOneAssociation) fields[i]);
            }
        }
        return oneToOneAssociationInstances;
    }
    // TODO: use a Hashtable instead
    public OneToOneAssociationInstance getOneToOneAssociation(
            OneToOneAssociation field) {
        OneToOneAssociationInstance[] oneToOneAssociationInstances = getOneToOneAssociationInstances();
        for(int i=0; i<oneToOneAssociationInstances.length; i++) {
            if (oneToOneAssociationInstances[i].getOneToOneAssociation() == field) {
                return oneToOneAssociationInstances[i];
            }
        }
        return null;
    }

    private ValueAssociationInstance[] valueAssociationInstances;
    public ValueAssociationInstance[] getValueAssociationInstances() {
        if (valueAssociationInstances == null) {
            NakedObjectField[] fields = getSpecification().getFields(NakedObjectField.VALUES);
            valueAssociationInstances = new ValueAssociationInstance[fields.length];
            for(int i=0; i<fields.length; i++) {
                valueAssociationInstances[i] = 
                    new ValueAssociationInstanceImpl(this, (ValueAssociation) fields[i]);
            }
        }
        return valueAssociationInstances;
    }

    // TODO: use a Hashtable instead
    public ValueAssociationInstance getValueAssociation(
            ValueAssociation field) {
        ValueAssociationInstance[] valueAssociationInstances = getValueAssociationInstances();
        for(int i=0; i<valueAssociationInstances.length; i++) {
            if (valueAssociationInstances[i].getValueAssociation() == field) {
                return valueAssociationInstances[i];
            }
        }
        return null;
    }

    public void addObjectListener(
            ObjectListener listener) {
    }

    public void removeObjectListener(
            ObjectListener listener) {
    }

    public void fireChangedEvent() {
        // TODO Auto-generated method stub
    }
    
}
// Copyright (c) Naked Objects Group Ltd.
