package org.nakedobjects.testing;

import java.util.Date;

import org.nakedobjects.noa.adapter.Version;


public class DummyVersion implements Version {
    private static final long serialVersionUID = 1L;
    private final int value;

    public DummyVersion() {
        this(-13);
    }

    public DummyVersion(final int value) {
        this.value = value;
    }

    public boolean equals(final Object obj) {
        if (obj instanceof DummyVersion) {
            DummyVersion other = (DummyVersion) obj;
            return other.value == value;
        }

        return false;
    }

    public boolean different(final Version version) {
        return value != ((DummyVersion) version).value;
    }

    public String toString() {
        return "DummyVersion#" + value;
    }

    public String getUser() {
        return "USER";
    }

    public Date getTime() {
        return new Date(0);
    }

    public Version next() {
        return new DummyVersion(value + 1);
    }

    public String sequence() {
        return "";
    }
}
// Copyright (c) Naked Objects Group Ltd.
