package org.nakedobjects.testing;

import org.easymock.MockControl;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.context.ContextDebug;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.UpdateNotifier;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.object.MessageBroker;


public class MockContext extends NakedObjectsContext {
    private MockControl persistorControl;
    private NakedObjectPersistor persistor;
    private MockControl specificationLoaderControl;
    private NakedObjectReflector specificationLoader;
    private MockControl objectLoaderControl;
    private NakedObjectLoader objectLoader;

    protected String executionContextId() {
        throw new UnexpectedCallException();
    }

    protected MessageBroker messageBroker() {
        throw new UnexpectedCallException();
    }

    protected NakedObjectLoader objectLoader() {
        return objectLoader;
    }

    protected NakedObjectPersistor objectPersistor() {
        return persistor;
    }

    protected Session session() {
        throw new UnexpectedCallException();
    }

    public void setObjectLoader(NakedObjectLoader loader) {
        throw new UnexpectedCallException();
    }

    public void setObjectPersistor(NakedObjectPersistor persistor) {
        throw new UnexpectedCallException();
    }

    public void setSession(Session session) {
        throw new UnexpectedCallException();
    }

    public void clearSession() {
        throw new UnexpectedCallException();
    }
    
    public void setReflector(NakedObjectReflector loader) {
        throw new UnexpectedCallException();
    }

    public void setTemplateImageLoader(TemplateImageLoader loader) {
        throw new UnexpectedCallException();
    }

    protected NakedObjectReflector reflector() {
        return specificationLoader;
    }

    protected UpdateNotifier updateNotifier() {
        throw new UnexpectedCallException();
    }

    protected TemplateImageLoader templateImageLoader() {
        return null;
    }

    protected void terminateSession() {}

    public String debugTitle() {
        return null;
    }

    public void replay() {
        if (objectLoaderControl != null) {
            objectLoaderControl.replay();
        }
        if (persistorControl != null) {
            persistorControl.replay();
        }
        if (specificationLoader != null) {
            specificationLoaderControl.replay();
        }
    }

    public void verify() {
        if (objectLoaderControl != null) {
            objectLoaderControl.verify();
        }
        if (persistorControl != null) {
            persistorControl.verify();
        }
        if (specificationLoader != null) {
            specificationLoaderControl.verify();
        }
    }

    public void initPersistor() {
        persistorControl = MockControl.createControl(NakedObjectPersistor.class);
        persistor = (NakedObjectPersistor) persistorControl.getMock();
    }

    public void initObjectLoader() {
        objectLoaderControl = MockControl.createControl(NakedObjectLoader.class);
        objectLoader = (NakedObjectLoader) objectLoaderControl.getMock();
    }

    public void initSpecificationLoader() {
        specificationLoaderControl = MockControl.createControl(NakedObjectReflector.class);
        specificationLoader = (NakedObjectReflector) specificationLoaderControl.getMock();
    }

    public void setReturnValue(Object object) {
        specificationLoaderControl.setReturnValue(object);
    }

    public void setReturnValue2(Object object) {
        persistorControl.setReturnValue(object);
    }

    protected String[] allExecutionContextIds() {
        return null;
    }

    protected ContextDebug debugContext(String executionContextId) {
        return null;
    }

    public void shutdownSession() {

    }
}

// Copyright (c) Naked Objects Group Ltd.
