package org.nakedobjects.testing;

import java.util.Hashtable;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.util.UnexpectedCallException;


public class TestOneToOneAssociation implements OneToOneAssociation {
    private final String name;
    private final Hashtable values = new Hashtable();
    private final TestSpecification spec;

    public TestOneToOneAssociation(String name2, String name, TestSpecification valueFieldSpec) {
        this.name = name;
        this.spec = valueFieldSpec;
    }

    public void clearAssociation(final NakedObject inObject, final NakedObject associate) {
        throw new UnexpectedCallException();
    }

    public String debugData() {
        return "";
    }

    public Naked get(NakedObject inObject) {
        return (Naked) values.get(inObject);
    }

    public String getBusinessKeyName() {
        return null;
    }

    public String getDescription() {
        return "no description";
    }
    
    public Object getExtension(final Class cls) {
        throw new UnexpectedCallException();
    }

    public Class[] getExtensions() {
        return new Class[0];
    }
    
    public String getHelp() {
        return "no help";
    }

    public String getId() {
        return  name;
    }

    public String getName() {
        return name;
    }

    public Naked[] getOptions(final NakedObject target) {
        return null;
    }

    public NakedObjectSpecification getSpecification() {
        return spec;
    }

    public void initAssociation(final NakedObject inObject, final NakedObject associate) {
        setAssociation(inObject, associate);
    }

    public Consent isAssociationValid(final NakedObject inObject, final NakedObject value) {
        throw new UnexpectedCallException();
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isPersisted() {
        return true;
    }

    public boolean isEmpty(final NakedObject inObject) {
        throw new UnexpectedCallException();
    }

    public boolean isMandatory() {
        throw new UnexpectedCallException();
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnable() {
        return false;
    }

    public Consent isUsable() {
        Consent usableDeclaratively = isUsableDeclaratively();
        if (usableDeclaratively.isVetoed()) {
            return usableDeclaratively;
        }
        return isUsableForSession();
    }

    public Consent isUsableDeclaratively() {
        return Allow.DEFAULT;
    }

    public Consent isUsableForSession() {
        return Allow.DEFAULT;
    }

    public Consent isUsable(final NakedReference target) {
        throw new UnexpectedCallException();
    }
    
    public boolean isValue() {
        return !isObject();
    }

    public boolean isVisible() {
        return isVisibleDeclaratively() && isVisibleForSession();
    }

    public boolean isVisibleDeclaratively() {
        throw new UnexpectedCallException();
    }

    public boolean isVisibleForSession() {
        throw new UnexpectedCallException();
    }

    public boolean isVisible(final NakedReference target) {
        throw new UnexpectedCallException();
    }

    public void setAssociation(final NakedObject inObject, final NakedObject associate) {
        values.put(inObject, associate);
    }
    
    public Object getDefault(
            NakedObject nakedObject) {
        return null;
    }

    public void toDefault(NakedObject target) {}


}
// Copyright (c) Naked Objects Group Ltd.
