package org.nakedobjects.testing;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.NakedObjectField.Filter;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;


public class TestSpecification implements NakedObjectSpecification {
    private static int next = 100;
    private NakedObjectAction action;
    public NakedObjectField[] fields = new NakedObjectField[0];
    private final int id = next++;
    private String name;
    private NakedObjectSpecification[] subclasses = new NakedObjectSpecification[0];
    private String title;
    private int type = OBJECT;

    public TestSpecification() {
        this((String) null);
    }

    public TestSpecification(final Class cls) {
        this(cls.getName());
    }

    public TestSpecification(final String name) {
        this.name = name == null ? "DummyNakedObjectSpecification#" + id : name;
        title = "";
    }

    public void addSubclass(final NakedObjectSpecification specification) {}

    public void clearDirty(final NakedObject object) {}

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void debugData(DebugString debug) {}

    public String debugInterface() {
        return null;
    }

    public String debugTitle() {
        return "";
    }

    public NakedObjectField[] getStaticallyVisibleFields() {
        return fields;
    }

    public NakedObject getAggregate(NakedObject object) {
        return null;
    }

    public NakedObjectAction getClassAction(
            final NakedObjectAction.Type type,
            final String name,
            final NakedObjectSpecification[] parameters) {
        return null;
    }

    public NakedObjectAction[] getClassActions(final NakedObjectAction.Type type) {
        return null;
    }

    public Object getExtension(final Class cls) {
        return null;
    }

    public Class[] getExtensions() {
        return new Class[0];
    }

    public int getFeatures() {
        return 0;
    }

    public NakedObjectField getField(final String name) {
        for (int i = 0; i < fields.length; i++) {
            if (fields[i].getId().equals(name)) {
                return fields[i];
            }
        }
        throw new NakedObjectRuntimeException("Field not found: " + name);
    }

    public Object getFieldExtension(final String name, final Class cls) {
        return null;
    }

    public Class[] getFieldExtensions(final String name) {
        return new Class[0];
    }

    public NakedObjectField[] getFields() {
        return fields;
    }

    public NakedObjectField[] getFields(final Filter filter) {
        NakedObjectField[] allFields = getFields();

        NakedObjectField[] selectedFields = new NakedObjectField[allFields.length];
        int v = 0;
        for (int i = 0; i < allFields.length; i++) {
            if (filter.accept(allFields[i])) {
                selectedFields[v++] = allFields[i];
            }
        }

        NakedObjectField[] fields = new NakedObjectField[v];
        System.arraycopy(selectedFields, 0, fields, 0, v);
        return fields;
    }

    public String getFullName() {
        return name;
    }

    public String getIconName(NakedReference reference) {
        return null;
    }

    public NakedObjectAction getObjectAction(
            final NakedObjectAction.Type type,
            final String name,
            final NakedObjectSpecification[] parameters) {
        if (action != null && action.getId().equals(name)) {
            return action;
        }
        return null;
    }

    public NakedObjectAction[] getObjectActions(final NakedObjectAction.Type type) {
        return null;
    }

    public String getPluralName() {
        return null;
    }

    public Class getSearchViaRepository() {
        return null;
    }

    public String getShortName() {
        return name.substring(name.lastIndexOf('.') + 1);
    }

    public String getSingularName() {
        return name + " (singular)";
    }

    public String getDescription() {
        return getSingularName();
    }

    public String getTitle(final NakedObject naked) {
        return title;
    }

    public int getType() {
        return type;
    }

    public NakedObjectField[] getDynamicallyVisibleFields(final NakedObject object) {
        return fields;
    }

    public boolean hasSubclasses() {
        return false;
    }

    public NakedObjectSpecification[] interfaces() {
        return new NakedObjectSpecification[0];
    }

    public void introspect() {}

    public boolean isDirty(final NakedObject object) {
        return false;
    }

    public boolean isOfType(final NakedObjectSpecification cls) {
        return cls == this;
    }

    public void markDirty(final NakedObject object) {}

    public Object newInstance() {
        throw new NakedObjectRuntimeException("Not able to create instance of " + getFullName()
                + "; newInstance() method should be overridden");
    }

    public Persistable persistable() {
        return Persistable.USER_PERSISTABLE;
    }

    public boolean queryByExample() {
        return false;
    }

    public void setupAction(final NakedObjectAction action) {
        this.action = action;
    }

    public void setupFields(final NakedObjectField[] fields) {
        this.fields = fields;
    }

    public void setupIsCollection() {
        type = COLLECTION;
    }

    public void setupIsObject() {
        type = OBJECT;
    }

    public void setupIsValue() {
        type = VALUE;
    }

    public void setupSubclasses(final NakedObjectSpecification[] subclasses) {
        this.subclasses = subclasses;
    }

    public void setupTitle(final String title) {
        this.title = title;
    }

    public NakedObjectSpecification[] subclasses() {
        return subclasses;
    }

    public NakedObjectSpecification superclass() {
        return null;
    }

    public String toString() {
        return getFullName();
    }

    public Consent isPersistable(NakedObject transientObject) {
        return null;
    }

    public void lifecycleEvent(NakedObject object, int event) {}

    public Object getDefaultValue() {
        return null;
    }

}
// Copyright (c) Naked Objects Group Ltd.
