package org.nakedobjects.testing;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.StaticContext;

//TODO combine with other version of TestSystem
public class TestSystem {
    private TestConfiguration configuration;
    private NakedObjectsContext nakedObjects;
    private final TestObjectLoader objectLoader;
    private NakedObjectPersistor objectPersistor;
    private final TestSpecificationLoader specificationLoader;

    public TestSystem() {
        specificationLoader = new TestSpecificationLoader();
        objectLoader = new TestObjectLoader();
        objectPersistor = new TestPersistor();
        configuration = new TestConfiguration();
    }

    public void addAdapterToObjectLoader(final Object object, final NakedObject adapter) {
        objectLoader.addAdapter(object, adapter);
    }

    public void addCollectionToObjectLoader(final NakedCollection collection) {
        objectLoader.addAdapter(collection.getObject(), collection);
    }

    public void addConfigurationProperty(String name, String value) {
        configuration.add(name, value);
    }

    public void addIdentityToObjectLoader(final Oid oid, final NakedReference adapter) {
        objectLoader.addIdentity(oid, adapter);
    }

    public void addRecreatedAdapterToObjectLoader(final Oid oid, final DummyNakedObject adapter) {
        objectLoader.addRecreated(oid, adapter);
    }

    public void addRecreatedTransientToObjectLoader(final DummyNakedObject adapter) {
        objectLoader.addRecreatedTransient(adapter);
    }

    public void addSpecificationToLoader(final NakedObjectSpecification specification) {
        specificationLoader.addSpecification(specification);
    }

    public void addSpecificationToLoader(final String name) {
        addSpecificationToLoader(new TestSpecification(name));
    }

    public void addValueToObjectLoader(final Object object, final NakedValue adapter) {
        objectLoader.addAdapter(object, adapter);

    }

    public NakedObject createAdapterForTransient(final Object associate) {
        NakedObject createAdapterForTransient = objectLoader.createAdapterForTransient(associate, false);
        objectLoader.addAdapter(associate, createAdapterForTransient);
        return createAdapterForTransient;
    }

    public void init() {
        nakedObjects = StaticContext.createInstance();

        NakedObjectsContext.setConfiguration(configuration);
        nakedObjects.setReflector(specificationLoader);
        nakedObjects.setObjectLoader(objectLoader);
        nakedObjects.setObjectPersistor(objectPersistor);
        nakedObjects.setSession(new TestSession());

        NakedObjectsContext.getReflector().init();
        NakedObjectsContext.getObjectLoader().init();
        NakedObjectsContext.getObjectPersistor().init();
    }

    public void setObjectPersistor(final NakedObjectPersistor objectPersistor) {
        this.objectPersistor = objectPersistor;
    }

    public void shutdown() {
        NakedObjectsContext.getReflector().shutdown();
        NakedObjectsContext.getObjectLoader().shutdown();
        NakedObjectsContext.getObjectPersistor().shutdown();
    }
}
// Copyright (c) Naked Objects Group Ltd.
