package org.nakedobjects.testing;

import org.nakedobjects.noa.adapter.FieldRegEx;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.spec.NakedObjectSpecification;


public class TestValueAdapter implements NakedValue {
    private String data;

    public TestValueAdapter() {
        data = "";
    }

    public TestValueAdapter(byte[] data) {
        this.data = new String(data);
    }

    public TestValueAdapter(String data) {
        this.data = data;
    }

    public String asEncodedString() {
        return data;
    }

    public boolean canClear() {
        return false;
    }

    public void clear() {}

    public boolean isEmpty() {
        return false;
    }

    public void parseTextEntry(String text) {}
    
    public void restoreFromEncodedString(String data) {
        this.data = data;
    }

    public void setMask(String mask) {}

    public void setRegEx(FieldRegEx regEx) {}

    public int defaultTypicalLength() {
        return 0;
    }

    public String getIconName() {
        return null;
    }

    public Object getObject() {
        return data;
    }

    public NakedObjectSpecification getSpecification() {
        return null;
    }

    public String titleString() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestValueAdapter) {
            TestValueAdapter other = (TestValueAdapter) obj;
            return data.equals(other.data);
            
        }

        return false;
    }

    
    public String toString() {
        return "TestValue " + data;
    }
}

// Copyright (c) Naked Objects Group Ltd.
