package test.org.nakedobjects.objects.specification;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.value.StringAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.testing.TestSpecification;

import test.org.nakedobjects.objects.bom.Movie;
import test.org.nakedobjects.objects.bom.Person;


class MovieDirectorField extends TestOneToOneAssociation {

    public void clearAssociation(final NakedObject inObject, final NakedObject associate) {
        if (getMovie(inObject).getDirector() != associate.getObject()) {
            throw new NakedObjectRuntimeException("clear value not set to " + getMovie(inObject).getDirector() + " but was "
                    + associate.getObject());
        }
        getMovie(inObject).setDirector(null);
    }

    public String debugData() {
        return "";
    }

    public Naked get(final NakedObject fromObject) {
        Person director = getMovie(fromObject).getDirector();
        if (director == null) {
            return null;
        } else {
            return NakedObjectsContext.getObjectLoader().getAdapterForElseCreateAdapterForTransient(director);
        }
    }

    public String getId() {
        return "director";
    }

    private Movie getMovie(final NakedObject inObject) {
        return (Movie) inObject.getObject();
    }

    public String getName() {
        return "Director";
    }

    public NakedObjectSpecification getSpecification() {
        return NakedObjectsContext.getReflector().loadSpecification(Person.class);
    }

    public void initAssociation(final NakedObject inObject, final NakedObject associate) {
        getMovie(inObject).setDirector(associate == null ? null : (Person) associate.getObject());
    }

    public Consent isAssociationValid(final NakedObject inObject, final NakedObject associate) {
        return Allow.DEFAULT;
    }

    public void setAssociation(final NakedObject inObject, final NakedObject associate) {
        getMovie(inObject).setDirector((Person) associate.getObject());
    }

    public Object getExtension(
            Class cls) {
        return null;
    }

    public Class[] getExtensions() {
        return new Class[]{};
    }

}

class MovieNameField extends TestValueField {
    public void clearValue(final NakedObject inObject) {
        getMovie(inObject).setName("");
    }

    public String debugData() {
        return "";
    }

    public Naked get(final NakedObject fromObject) {
        return new StringAdapter(getMovie(fromObject).getName());
    }

    public String getId() {
        return "name";
    }

    private Movie getMovie(final NakedObject inObject) {
        return (Movie) inObject.getObject();
    }

    public String getName() {
        return "Name";
    }

    public NakedObjectSpecification getSpecification() {
        return new TestSpecification("java.lang.String");
    }

    public void initValue(final NakedObject inObject, final NakedValue value) {
        getMovie(inObject).setName((String) value.getObject());
    }

    public Consent isValueValid(final NakedObject inObject, final NakedValue value) {
        return Allow.DEFAULT;
    }

    public void setValue(final NakedObject inObject, final NakedValue value) {
        getMovie(inObject).setName((String) value.getObject());
    }
    
    public Object getExtension(
            Class cls) {
        return null;
    }

    public Class[] getExtensions() {
        return new Class[]{};
    }


}

// Copyright (c) Naked Objects Group Ltd.

public class MovieSpecification extends TestSpecification {

    public MovieSpecification() {
        fields = new NakedObjectField[] { new MovieNameField(), new MovieDirectorField(),
        // new MovieRolesField()
        };
    }

    public NakedObjectAction getClassAction(
            final NakedObjectAction.Type type,
            final String name,
            final NakedObjectSpecification[] parameters) {
        return null;
    }

    public String getFullName() {
        return Movie.class.getName();
    }

    public NakedObjectAction getObjectAction(final NakedObjectAction.Type type, final String name) {
        return null;
    }

    public NakedObjectAction getObjectAction(
            final NakedObjectAction.Type type,
            final String name,
            final NakedObjectSpecification[] parameters) {
        return null;
    }

    public NakedObjectAction[] getObjectActions(final NakedObjectAction.Type type) {
        return null;
    }

    public String getPluralName() {
        return "Movies";
    }

    public String getShortName() {
        return "movie";
    }

    public String getSingularName() {
        return "Movie";
    }

    public String getTitle(final NakedObject naked) {
        return ((Movie) naked.getObject()).title();
    }

    public boolean isObject() {
        return true;
    }

    public Object newInstance() {
        return new Movie();
    }
}
