package test.org.nakedobjects.objects.specification;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.Formatter;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.nof.core.reflect.Allow;


public abstract class TestValueField implements ValueAssociation {
    public boolean canClear() {
        return false;
    }
    
    public boolean canWrap() {
        return false;
    }
    
    public String getDescription() {
        return "";
    }

//    public Object getExtension(final Class cls) {
//        return null;
//    }
//
//    public Class[] getExtensions() {
//        return new Class[0];
//    }

    public Formatter getFormatter() {
        return null;
    }
    
    public String getBusinessKeyName() {
        return "";
    }
    
    public Naked[] getOptions(final NakedObject target) {
        return null;
    }
    
    public int getMaximumLength() {
        return 0;
    }

    public int getNoLines() {
        return 0;
    }
    
    public int getTypicalLineLength() {
        return 0;
    }
    
    public String getHelp() {
        return "";
    }

    public Consent isUsable() {
        Consent usableDeclaratively = isUsableDeclaratively();
        if (usableDeclaratively.isVetoed()) {
            return usableDeclaratively;
        }
        return isUsableForSession();
    }
    
    public Consent isUsableDeclaratively() {
        return Allow.DEFAULT;
    }

    public Consent isUsableForSession() {
        return Allow.DEFAULT;
    }

    public boolean isVisible() {
        return isVisibleDeclaratively() && isVisibleForSession();
    }

    public boolean isVisibleDeclaratively() {
        return true;
    }

    public boolean isVisibleForSession() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isPersisted() {
        return true;
    }

    public boolean isEmpty(final NakedObject adapter) {
        return false;
    }

    public boolean isMandatory() {
        return false;
    }

    public boolean isOptionEnable() {
        return false;
    }
    
    public boolean isObject() {
        return false;
    }

    public Consent isUsable(final NakedReference target) {
        return Allow.DEFAULT;
    }

    public boolean isValue() {
        return true;
    }

    public boolean isVisible(final NakedReference target) {
        return true;
    }
    
    public Object getDefault(
            NakedObject nakedObject) {
        // TODO Auto-generated method stub
        return null;
    }

    public void toDefault(NakedObject target) {}
}
// Copyright (c) Naked Objects Group Ltd.
