/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.testing.TestSystem;

public abstract class AbstractValueAdapterTestCase
extends TestCase {
    protected NakedValue value;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        new TestSystem().init();
    }

    public void testIsEmpty() throws Exception {
        AbstractValueAdapterTestCase.assertFalse((boolean)this.value.isEmpty());
    }

    public void testClear() throws Exception {
        this.value.clear();
        AbstractValueAdapterTestCase.assertTrue((boolean)this.value.isEmpty());
    }

    public void testCanClear() throws Exception {
        AbstractValueAdapterTestCase.assertEquals((boolean)true, (boolean)this.value.canClear());
    }

    public void testParseNull() throws Exception {
        try {
            this.value.parseTextEntry(null);
            AbstractValueAdapterTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParseEmptyString() throws Exception {
        this.value.parseTextEntry("");
        AbstractValueAdapterTestCase.assertTrue((boolean)this.value.isEmpty());
    }

    public void testDecodeNULL() throws Exception {
        this.value.restoreFromEncodedString("NULL");
        AbstractValueAdapterTestCase.assertTrue((boolean)this.value.isEmpty());
    }

    public void testToStringDoesNotFail() throws Exception {
        this.value.toString();
    }
}

