/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.math.BigDecimal;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.BigDecimalAdapter;

public class BigDecimalAdapterTest
extends AbstractValueAdapterTestCase {
    private BigDecimalAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        this.value = new BigDecimalAdapter(new BigDecimal("132.199"));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testParseValidString() throws Exception {
        this.value.parseTextEntry("2142342334");
        BigDecimalAdapterTest.assertEquals((Object)new BigDecimal(2142342334L), (Object)this.value.bigDecimalValue());
    }

    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry("214xxx2342334");
            BigDecimalAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testTitle() throws Exception {
        BigDecimalAdapterTest.assertEquals((String)"132.199", (String)this.value.titleString());
    }

    public void testEncode() throws Exception {
        BigDecimalAdapterTest.assertEquals((String)"132.199", (String)this.value.asEncodedString());
    }

    public void testDecode() throws Exception {
        this.value.restoreFromEncodedString("4322.89991");
        BigDecimalAdapterTest.assertEquals((Object)new BigDecimal("4322.89991"), (Object)this.value.bigDecimalValue());
    }
}

