/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.math.BigInteger;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.BigIntegerAdapter;

public class BigIntAdapterTest
extends AbstractValueAdapterTestCase {
    private BigIntegerAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        this.value = new BigIntegerAdapter(new BigInteger("132199"));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testParseValidString() throws Exception {
        this.value.parseTextEntry("2142342334");
        BigIntAdapterTest.assertEquals((Object)new BigInteger("2142342334"), (Object)this.value.bigIntegerValue());
    }

    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry("214xxx2342334");
            BigIntAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testTitle() throws Exception {
        BigIntAdapterTest.assertEquals((String)"132,199", (String)this.value.titleString());
    }

    public void testEncode() throws Exception {
        BigIntAdapterTest.assertEquals((String)"132199", (String)this.value.asEncodedString());
    }

    public void testDecode() throws Exception {
        this.value.restoreFromEncodedString("432289991");
        BigIntAdapterTest.assertEquals((Object)new BigInteger("432289991"), (Object)this.value.bigIntegerValue());
    }
}

