/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.DateAdapter;

public class DateAdapterTest
extends AbstractValueAdapterTestCase {
    private DateAdapter adapter;

    public static void main(String[] args) {
        TestRunner.run(DateAdapterTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Date date = new Date(0L);
        this.adapter = new DateAdapter(date);
        this.value = this.adapter;
    }

    public void testDateValue() {
        DateAdapterTest.assertEquals((Object)new Date(0L), (Object)this.adapter.dateValue());
        this.adapter.setValue(new Date(50000L));
        DateAdapterTest.assertEquals((Object)new Date(50000L), (Object)this.adapter.dateValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            this.adapter.parseTextEntry("date");
            DateAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        DateAdapterTest.assertEquals((int)0, (int)this.adapter.getMaximumLength());
        DateAdapterTest.assertEquals((int)0, (int)this.adapter.getMinumumLength());
    }

    public void testOutputAsString() {
        this.adapter.setMask("yyyy-MM-dd");
        DateAdapterTest.assertEquals((String)"1970-01-01", (String)this.adapter.titleString());
    }

    public void testParse() throws Exception {
        this.adapter.parseTextEntry("1/1/1980");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        calendar.set(1980, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DateAdapterTest.assertEquals((Object)calendar.getTime(), (Object)this.adapter.dateValue());
    }
}

