/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.DateTimeAdapter;

public class DateTimeAdapterTest
extends AbstractValueAdapterTestCase {
    private DateTimeAdapter adapter;

    public static void main(String[] args) {
        TestRunner.run(DateTimeAdapterTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        java.sql.Date date = new java.sql.Date(0L);
        this.adapter = new DateTimeAdapter((Date)date);
        this.value = this.adapter;
    }

    public void testDateValue() {
        DateTimeAdapterTest.assertEquals((Object)new java.sql.Date(0L), (Object)this.adapter.dateValue());
        this.adapter.setValue((Date)new java.sql.Date(50000L));
        DateTimeAdapterTest.assertEquals((Object)new java.sql.Date(50000L), (Object)this.adapter.dateValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            this.adapter.parseTextEntry("date");
            DateTimeAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        DateTimeAdapterTest.assertEquals((int)0, (int)this.adapter.getMaximumLength());
        DateTimeAdapterTest.assertEquals((int)0, (int)this.adapter.getMinumumLength());
    }

    public void testOutputAsString() {
        this.adapter.setMask("yyyy-MM-dd hh:mm");
        DateTimeAdapterTest.assertEquals((String)"1970-01-01 12:00", (String)this.adapter.titleString());
    }

    public void testParse() throws Exception {
        this.adapter.setMask("yyyy-MM-dd hh:mm");
        this.adapter.parseTextEntry("1980-01-01 10:40");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        calendar.set(1980, 0, 1, 10, 40, 0);
        calendar.set(14, 0);
        DateTimeAdapterTest.assertEquals((Object)calendar.getTime(), (Object)this.adapter.dateValue());
    }
}

