/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.DoubleAdapter;
import org.nakedobjects.testing.TestSystem;

public class DoubleAdapterTest
extends AbstractValueAdapterTestCase {
    private DoubleAdapter value;

    public static void main(String[] args) {
        TestRunner.run(DoubleAdapterTest.class);
    }

    protected void setUp() throws Exception {
        new TestSystem().init();
        this.value = new DoubleAdapter(new Double(32.5));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testValue() {
        DoubleAdapterTest.assertEquals((double)32.5, (double)this.value.doubleValue(), (double)0.0);
    }

    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry("one");
            DoubleAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        DoubleAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        DoubleAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testOutputAsString() {
        DoubleAdapterTest.assertEquals((String)"32.5", (String)this.value.titleString());
        this.value.setValue(Double.valueOf(3.5E7));
        DoubleAdapterTest.assertEquals((String)"35,000,000", (String)this.value.titleString());
    }

    public void testParse() throws Exception {
        this.value.parseTextEntry("120.56");
        DoubleAdapterTest.assertEquals((double)120.56, (double)this.value.doubleValue(), (double)0.0);
        this.value.parseTextEntry("1,20.0");
        DoubleAdapterTest.assertEquals((double)120.0, (double)this.value.doubleValue(), (double)0.0);
    }
}

