/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.FloatAdapter;

public class FloatAdapterTest
extends AbstractValueAdapterTestCase {
    private FloatAdapter value;

    public static void main(String[] args) {
        TestRunner.run(FloatAdapterTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.value = new FloatAdapter(new Float(32.5f));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testFloatValue() {
        FloatAdapterTest.assertEquals((double)32.5, (double)this.value.floatValue().floatValue(), (double)0.0);
    }

    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry("one");
            FloatAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        FloatAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        FloatAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testOutputAsString() {
        FloatAdapterTest.assertEquals((String)"32.5", (String)this.value.titleString());
        this.value.setValue(Float.valueOf(3.5E7f));
        FloatAdapterTest.assertEquals((String)"35,000,000", (String)this.value.titleString());
    }

    public void testParse() throws Exception {
        this.value.parseTextEntry("120.50");
        FloatAdapterTest.assertEquals((double)120.5, (double)this.value.floatValue().floatValue(), (double)0.0);
        this.value.parseTextEntry("1,20.0");
        FloatAdapterTest.assertEquals((double)120.0, (double)this.value.floatValue().floatValue(), (double)0.0);
    }

    public void testIsNotEmpty() throws Exception {
        FloatAdapterTest.assertFalse((boolean)this.value.isEmpty());
    }

    public void testEncode() throws Exception {
        FloatAdapterTest.assertEquals((String)"32.5", (String)this.value.asEncodedString());
    }

    public void testDescode() throws Exception {
        this.value.restoreFromEncodedString("10.25");
        FloatAdapterTest.assertEquals((double)10.25, (double)this.value.floatValue().floatValue(), (double)0.0);
    }
}

