/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.LongAdapter;
import org.nakedobjects.testing.TestSystem;

public class LongAdapterTest
extends AbstractValueAdapterTestCase {
    private LongAdapter value;

    public static void main(String[] args) {
        TestRunner.run(LongAdapterTest.class);
    }

    protected void setUp() throws Exception {
        new TestSystem().init();
        this.value = new LongAdapter(new Long(32L));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testIntegerValue() {
        LongAdapterTest.assertEquals((long)32L, (long)this.value.longValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry("one");
            LongAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        LongAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        LongAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testOutputAsString() {
        LongAdapterTest.assertEquals((String)"32", (String)this.value.titleString());
        this.value.setValue(Long.valueOf(-128L));
        LongAdapterTest.assertEquals((String)"-128", (String)this.value.titleString());
    }

    public void testParse() throws Exception {
        this.value.parseTextEntry("120");
        LongAdapterTest.assertEquals((long)120L, (long)this.value.longValue());
        this.value.parseTextEntry("1,20.0");
        LongAdapterTest.assertEquals((long)120L, (long)this.value.longValue());
    }
}

