/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.StringAdapter;

public class StringAdapterTest
extends AbstractValueAdapterTestCase {
    private StringAdapter value;

    public static void main(String[] args) {
        TestRunner.run(StringAdapterTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.value = new StringAdapter("text entry");
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testStringValue() {
        StringAdapterTest.assertEquals((String)"text entry", (String)this.value.stringValue());
    }

    public void testLengths() {
        StringAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        StringAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testOutputAsString() {
        StringAdapterTest.assertEquals((String)"text entry", (String)this.value.titleString());
    }

    public void testParse() throws Exception {
        this.value.parseTextEntry("tRUe");
        StringAdapterTest.assertEquals((String)"tRUe", (String)this.value.stringValue());
        this.value.parseTextEntry("fALse");
        StringAdapterTest.assertEquals((String)"fALse", (String)this.value.stringValue());
    }

    public void testEncodeNormalString() throws Exception {
        this.value = new StringAdapter("/slash");
        StringAdapterTest.assertEquals((String)"//slash", (String)this.value.asEncodedString());
    }

    public void testEncodeNULLString() throws Exception {
        this.value = new StringAdapter("NULL");
        StringAdapterTest.assertEquals((String)"/NULL", (String)this.value.asEncodedString());
    }

    public void testRestore() throws Exception {
        this.value.restoreFromEncodedString("//slash");
        StringAdapterTest.assertEquals((String)"/slash", (String)this.value.stringValue());
    }

    public void testRestoreNULLString() throws Exception {
        this.value.restoreFromEncodedString("/NULL");
        StringAdapterTest.assertEquals((String)"NULL", (String)this.value.stringValue());
    }
}

