/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.conf;

import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.nof.core.conf.PropertiesConfiguration;

public class PropertiesConfigurationTest
extends TestCase {
    private PropertiesConfiguration configuration;

    public static void main(String[] args) {
        TestRunner.run(PropertiesConfigurationTest.class);
    }

    public PropertiesConfigurationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        BasicConfigurator.configure();
        LogManager.getRootLogger().setLevel(Level.OFF);
        this.configuration = new PropertiesConfiguration();
        Properties p = new Properties();
        p.put("nakedobjects.bool", "on");
        p.put("nakedobjects.str", "string");
        this.configuration.add(p);
        Properties p1 = new Properties();
        p1.put("nakedobjects.int", "1");
        p1.put("nakedobjects.str", "replacement");
        this.configuration.add(p1);
    }

    public void testDuplicatedPropertyName() {
        PropertiesConfigurationTest.assertEquals((String)"replacement", (String)this.configuration.getString("nakedobjects.str"));
    }

    public void testUniqueEntries() {
        PropertiesConfigurationTest.assertEquals((int)1, (int)this.configuration.getInteger("nakedobjects.int"));
        PropertiesConfigurationTest.assertEquals((boolean)true, (boolean)this.configuration.getBoolean("nakedobjects.bool"));
    }
}

