/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.util;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.nof.core.util.Profiler;
import org.nakedobjects.nof.core.util.ProfilerSystem;
import org.nakedobjects.nof.core.util.ProfilerTestSystem;

public class ProfilerTest
extends TestCase {
    private Profiler profiler;

    public static void main(String[] args) {
        TestRunner.run(ProfilerTest.class);
    }

    public void setUp() {
        Profiler.setProfilerSystem((ProfilerSystem)new ProfilerTestSystem());
        this.profiler = new Profiler("name");
    }

    public void testFreeMemory() {
        ProfilerTest.assertEquals((String)"20,300 bytes", (String)Profiler.memoryLog());
    }

    public void testMemoryUsage() {
        ProfilerTest.assertEquals((long)10300L, (long)this.profiler.getMemoryUsage());
        ProfilerTest.assertEquals((long)20000L, (long)this.profiler.getMemoryUsage());
    }

    public void testMemoryUsageLog() {
        ProfilerTest.assertEquals((String)"10,300 bytes", (String)this.profiler.memoryUsageLog());
    }

    public void testTiming() {
        this.profiler.start();
        this.profiler.stop();
        ProfilerTest.assertEquals((long)100L, (long)this.profiler.getElapsedTime());
    }

    public void testTimingLog() {
        this.profiler.start();
        this.profiler.stop();
        ProfilerTest.assertEquals((String)"0.1 secs", (String)this.profiler.timeLog());
    }

    public void testContinueWithStartAndStopPausesTiming() {
        this.profiler.start();
        this.profiler.stop();
        this.profiler.start();
        this.profiler.stop();
        ProfilerTest.assertEquals((long)400L, (long)this.profiler.getElapsedTime());
    }

    public void testResetDuringTiming() {
        this.profiler.start();
        this.profiler.reset();
        ProfilerTest.assertEquals((long)200L, (long)this.profiler.getElapsedTime());
    }

    public void testResetAfterStopResetsToZero() {
        this.profiler.start();
        this.profiler.stop();
        this.profiler.reset();
        ProfilerTest.assertEquals((long)0L, (long)this.profiler.getElapsedTime());
        this.profiler.start();
        this.profiler.stop();
        ProfilerTest.assertEquals((long)400L, (long)this.profiler.getElapsedTime());
    }

    public void testZero() {
        ProfilerTest.assertEquals((long)0L, (long)this.profiler.getElapsedTime());
    }

    public void testRepeatedElapseTimeAfterStopGivesSameTime() {
        this.profiler.start();
        this.profiler.stop();
        ProfilerTest.assertEquals((long)100L, (long)this.profiler.getElapsedTime());
        ProfilerTest.assertEquals((long)100L, (long)this.profiler.getElapsedTime());
        ProfilerTest.assertEquals((long)100L, (long)this.profiler.getElapsedTime());
    }

    public void testRepeatedElapseTimeGivesLatestTime() {
        this.profiler.start();
        ProfilerTest.assertEquals((long)100L, (long)this.profiler.getElapsedTime());
        ProfilerTest.assertEquals((long)300L, (long)this.profiler.getElapsedTime());
        ProfilerTest.assertEquals((long)600L, (long)this.profiler.getElapsedTime());
    }
}

