/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.testsystem;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.StaticContext;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyObjectLoader;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxyPersistor;
import org.nakedobjects.nof.testsystem.TestProxyReflector;
import org.nakedobjects.nof.testsystem.TestProxySpecification;
import org.nakedobjects.testing.TestConfiguration;
import org.nakedobjects.testing.TestSession;

public class TestProxySystem {
    private int nextId = 1;
    private TestConfiguration configuration;
    private NakedObjectsContext nakedObjects;
    private final TestProxyObjectLoader objectLoader;
    private NakedObjectPersistor persistor;
    private final TestProxyReflector reflector = new TestProxyReflector();

    public TestProxySystem() {
        this.objectLoader = new TestProxyObjectLoader();
        this.persistor = new TestProxyPersistor();
        this.configuration = new TestConfiguration();
    }

    public NakedObject createAdapterForTransient(Object associate) {
        NakedObject createAdapterForTransient = this.objectLoader.createAdapterForTransient(associate, false);
        this.objectLoader.addAdapter(associate, createAdapterForTransient);
        return createAdapterForTransient;
    }

    public void init() {
        this.nakedObjects = StaticContext.createInstance();
        NakedObjectsContext.setConfiguration((NakedObjectConfiguration)this.configuration);
        this.nakedObjects.setReflector((NakedObjectReflector)this.reflector);
        this.nakedObjects.setObjectLoader((NakedObjectLoader)this.objectLoader);
        this.nakedObjects.setObjectPersistor(this.persistor);
        this.nakedObjects.setSession((Session)new TestSession());
        NakedObjectsContext.getReflector().init();
        NakedObjectsContext.getObjectLoader().init();
        NakedObjectsContext.getObjectPersistor().init();
    }

    public void shutdown() {
        NakedObjectsContext.getReflector().shutdown();
        NakedObjectsContext.getObjectLoader().shutdown();
        NakedObjectsContext.getObjectPersistor().shutdown();
    }

    public void resetLoader() {
        NakedObjectsContext.getObjectLoader().reset();
    }

    public TestProxyNakedObject createPersistentTestObject() {
        TestPojo pojo = new TestPojo();
        return this.createPersistentTestObject(pojo);
    }

    public TestProxyNakedObject createPersistentTestObject(TestPojo pojo) {
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupObject(pojo);
        Oid oid = this.persistor.createTransientOid((Object)pojo);
        this.persistor.convertTransientToPersistentOid(oid);
        adapter.setupOid(oid);
        adapter.setupResolveState(ResolveState.TRANSIENT);
        this.setUpSpecification(pojo, adapter);
        this.addAdapterToLoader(pojo, adapter);
        this.persistor.makePersistent((NakedObject)adapter);
        return adapter;
    }

    private void setUpSpecification(TestPojo pojo, TestProxyNakedObject adapter) {
        adapter.setupSpecification(this.reflector.loadSpecification(pojo.getClass()));
    }

    private void addAdapterToLoader(TestPojo pojo, NakedObject adapter) {
        this.objectLoader.addAdapter((Object)pojo, adapter);
        this.objectLoader.addIdentity(adapter.getOid(), (NakedReference)adapter);
    }

    public TestProxyNakedObject createTransientTestObject() {
        TestPojo pojo = new TestPojo();
        return this.createTransientTestObject(pojo);
    }

    public TestProxyNakedObject createTransientTestObject(TestPojo pojo) {
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupOid(new TestProxyOid(this.nextId++, false));
        adapter.setupVersion(null);
        adapter.setupResolveState(ResolveState.TRANSIENT);
        adapter.setupObject(pojo);
        this.setUpSpecification(pojo, adapter);
        this.addAdapterToLoader(pojo, adapter);
        return adapter;
    }

    public TestProxySpecification getSpecification(Class cls) {
        return (TestProxySpecification)this.reflector.loadSpecification(cls);
    }

    public void setObjectPersistor(NakedObjectPersistor persistor) {
        this.persistor = persistor;
    }
}

