/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.testsystem.tests;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyException;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySystem;

public class CreateTransientObjectsTest
extends TestCase {
    private TestProxySystem system;
    private TestProxyNakedObject adapter;
    private TestPojo pojo;
    private Oid oid;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.system = new TestProxySystem();
        this.system.init();
        this.pojo = new TestPojo();
        this.adapter = this.system.createTransientTestObject(this.pojo);
        this.oid = this.adapter.getOid();
    }

    public void testSpecification() {
        CreateTransientObjectsTest.assertNotNull((Object)this.adapter.getSpecification());
        CreateTransientObjectsTest.assertNotNull((String)TestPojo.class.getName(), (Object)this.adapter.getSpecification().getFullName());
    }

    public void testStateOfCreatedAdapted() {
        CreateTransientObjectsTest.assertNotNull((Object)this.adapter);
        CreateTransientObjectsTest.assertEquals((Object)new TestProxyOid(1, false), (Object)this.oid);
        CreateTransientObjectsTest.assertNull((Object)this.adapter.getVersion());
        CreateTransientObjectsTest.assertEquals((Object)ResolveState.TRANSIENT, (Object)this.adapter.getResolveState());
        CreateTransientObjectsTest.assertEquals((Object)this.pojo, (Object)this.adapter.getObject());
    }

    public void test2ndPersistentCreationHasDifferentOid() {
        TestPojo pojo = new TestPojo();
        TestProxyNakedObject adapter2 = this.system.createTransientTestObject(pojo);
        CreateTransientObjectsTest.assertNotNull((Object)adapter2);
        CreateTransientObjectsTest.assertEquals((Object)new TestProxyOid(2, false), (Object)adapter2.getOid());
    }

    public void testIsAddedToObjectLoader() {
        NakedObject a = NakedObjectsContext.getObjectLoader().getAdapterFor(this.oid);
        CreateTransientObjectsTest.assertEquals((Object)this.adapter, (Object)a);
    }

    public void testAddedToPersistor() {
        this.system.resetLoader();
        try {
            NakedObjectsContext.getObjectPersistor().getObject(this.oid, null);
            CreateTransientObjectsTest.fail();
        }
        catch (TestProxyException testProxyException) {
            // empty catch block
        }
    }
}

