package org.nakedobjects.nof.persist.objectstore.inmemory;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.nof.core.persist.TitleCriteria;


/*
 * The objects need to store in a repeatable sequence so the elements and instances method return the same data for any repeated
 * call, and so that one subset of instances follows on the previous. This is done by keeping the objects in the order that they
 * where created.
 */
public class MemoryObjectStoreInstances {
    protected final Hashtable objectInstances = new Hashtable();
    protected final Hashtable titleIndex = new Hashtable();
    private NakedObjectLoader objectLoader;

    public MemoryObjectStoreInstances(final NakedObjectLoader objectLoader) {
        this.objectLoader = objectLoader;
    }

    public Enumeration elements() {
        Vector v = new Vector(objectInstances.size());
        for (Enumeration e = objectInstances.keys(); e.hasMoreElements();) {
            Oid oid = (Oid) e.nextElement();
            v.addElement(getObject(oid));
        }
        return v.elements();
    }

    public NakedObject getObject(final Oid oid) {
        Object pojo = objectInstances.get(oid);
        if (pojo == null) {
            return null;
        }
        NakedObject adapter;
        adapter = objectLoader.recreateAdapter(oid, pojo);
        return adapter;
    }

    public boolean hasInstances() {
        return numberOfInstances() > 0;
    }

    public void instances(final InstancesCriteria criteria, final Vector instances) {
        if (criteria instanceof TitleCriteria) {
            Enumeration keys = titleIndex.keys();
            while (keys.hasMoreElements()) {
                String title = (String) keys.nextElement();
                if (((TitleCriteria) criteria).matches(title)) {
                    Oid oid = (Oid) titleIndex.get(title);
                    instances.add(getObject(oid));
                }
            }
            return;
        }

        Enumeration e = elements();
        while (e.hasMoreElements()) {
            NakedObject element = (NakedObject) e.nextElement();
            if (criteria.matches(element)) {
                instances.addElement(element);
            }
        }
    }

    public int numberOfInstances() {
        return objectInstances.size();
    }

    public void remove(final Oid oid) {
        objectInstances.remove(oid);
    }

    public void save(final NakedObject object) {
        objectInstances.put(object.getOid(), object.getObject());
        titleIndex.put(object.titleString().toLowerCase(), object.getOid());
    }

    public void shutdown() {
        objectInstances.clear();
        titleIndex.clear();
    }
}
// Copyright (c) Naked Objects Group Ltd.
