package org.nakedobjects.nof.persist.objectstore.inmemory;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.ObjectNotFoundException;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;


/*
 * The objects need to store in a repeatable sequence so the
 * instances method return the same data for any repeated call, and so that one
 * subset of instances follows on the previous. This is done by keeping the
 * objects in the order that they where created.
 */
class TransientObjectStoreInstances {
    protected final Vector objectInstances = new Vector();

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(TransientObjectStoreInstances.class).info("finalizing instances");
    }

    public boolean hasInstances() {
        return numberOfInstances() > 0;
    }

    public void instances(final Vector instances) {
        Enumeration e = objectInstances.elements();
        while (e.hasMoreElements()) {
            NakedObject object = (NakedObject) e.nextElement();
            instances.addElement(object);
        }
    }

    public int numberOfInstances() {
        return objectInstances.size();
    }

    public void remove(final NakedObject object) {
        if (!objectInstances.removeElement(object)) {
            throw new ObjectNotFoundException(object);
        }
    }

    public void add(final NakedObject object) {
        objectInstances.addElement(object);
    }

    public void save(final NakedObject object) {}

    public void shutdown() {
        objectInstances.removeAllElements();
    }

}
// Copyright (c) Naked Objects Group Ltd.
