package org.nakedobjects.nof.persist.objectstore;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.nof.persist.DummyPersistAlgorithm;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxySystem;
import org.nakedobjects.testing.TestSpecification;

import test.org.nakedobjects.object.persistence.defaults.DummyOidGenerator;


public class ObjectPersistorTest extends TestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(ObjectPersistorTest.class);
    }

    private ObjectStorePersistor persistor;
    private TestSpecification objectSpecification;
    private MockObjectStore objectStore;
    private TestProxyNakedObject testNakedObject;
    private TestProxySystem system;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);

        system = new TestProxySystem();

        persistor = new ObjectStorePersistor();
        objectStore = new MockObjectStore();
        persistor.setObjectStore(objectStore);
        persistor.setServices(new Object[0]);
        persistor.setPersistAlgorithm(new DummyPersistAlgorithm());
        persistor.setOidGenerator(new DummyOidGenerator());

        system.setObjectPersistor(persistor);

        system.init();

        testNakedObject = system.createPersistentTestObject();
        objectSpecification = new TestSpecification();
        testNakedObject.setupSpecification(objectSpecification);
        
        objectStore.reset();
    }

    protected void tearDown() throws Exception {
        system.shutdown();
    }

    public void testAbort() {
        persistor.startTransaction();
        persistor.destroyObject(testNakedObject);
        persistor.abortTransaction();

        objectStore.assertAction(0, "startTransaction");
        objectStore.assertAction(1, "destroyObject " + testNakedObject);
        objectStore.assertAction(2, "abortTransaction");
        objectStore.assertLastAction(2);
    }

    public void testEndTransaction() {
        persistor.startTransaction();
        persistor.destroyObject(testNakedObject);
        persistor.endTransaction();

        objectStore.assertAction(0, "startTransaction");
        objectStore.assertAction(1, "destroyObject " + testNakedObject);
        objectStore.assertAction(2, "endTransaction");
        objectStore.assertAction(3, "run DestroyObjectCommand " + testNakedObject);
    }

    public void testDestroy() {
        objectSpecification.fields = new NakedObjectField[0];
        persistor.startTransaction();
        persistor.destroyObject(testNakedObject);
        persistor.endTransaction();

        objectStore.assertAction(0, "startTransaction");
        objectStore.assertAction(1, "destroyObject " + testNakedObject);
        objectStore.assertAction(2, "endTransaction");
        objectStore.assertAction(3, "run DestroyObjectCommand " + testNakedObject);

        assertEquals(4, objectStore.getActions().size());
    }

    public void testMakePersistent() {
        objectSpecification.fields = new NakedObjectField[0];

        testNakedObject.setupResolveState(ResolveState.TRANSIENT);

        persistor.startTransaction();
        persistor.makePersistent(testNakedObject);
        persistor.endTransaction();

        objectStore.assertAction(0, "startTransaction");
        objectStore.assertAction(1, "createObject " + testNakedObject);
        objectStore.assertAction(2, "endTransaction");
        objectStore.assertAction(3, "run CreateObjectCommand " + testNakedObject);

        assertEquals(4, objectStore.getActions().size());
    }
}
// Copyright (c) Naked Objects Group Ltd.
