package org.nakedobjects.nof.persist.objectstore.inmemory;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.persist.TitleCriteria;
import org.nakedobjects.nof.testsystem.ProxyTestCase;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyOid;


public class EmptyMemoryObjectStoreTest extends ProxyTestCase {
    private MemoryObjectStore store;

    protected void setUp() throws Exception {
        super.setUp();
        store = new MemoryObjectStore();
    }

    protected void tearDown() throws Exception {
        store.shutdown();
        super.tearDown();
    }

    public void testStartsUpInUnitializedSate() throws Exception {
        assertFalse(store.isInitialized());
    }

    public void testFindNoInstances() throws Exception {
        NakedObjectSpecification spec = system.getSpecification(TestPojo.class);
        NakedObject[] instances = store.getInstances(new TitleCriteria(spec, "title", false));
        assertEquals(0, instances.length);
    }


    public void testHasNoInstances() throws Exception {
        NakedObjectSpecification spec = system.getSpecification(TestPojo.class);
        assertFalse(store.hasInstances(spec, false));
    }

    public void testCantFindObjectByOid() {
        NakedObjectSpecification spec = system.getSpecification(TestPojo.class);
        Oid oid = new TestProxyOid(10, true);
        try {
            store.getObject(oid, spec);
            fail();
        } catch (ObjectNotFoundException expected) {
        }
    }
    
    public void testName() throws Exception {
        assertEquals("In-Memory Object Store", store.name());
    
    }
    
    public void testOidForService() throws Exception {
        Oid oidForService = store.getOidForService("service name");
        assertEquals(null, oidForService);
    }

}

// Copyright (c) Naked Objects Group Ltd.
