/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.persist.OidGenerator;
import org.nakedobjects.nof.persist.DummyPersistAlgorithm;
import org.nakedobjects.nof.persist.PersistAlgorithm;
import org.nakedobjects.nof.persist.objectstore.MockObjectStore;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.objectstore.ObjectStorePersistor;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxySystem;
import org.nakedobjects.testing.TestSpecification;
import test.org.nakedobjects.object.persistence.defaults.DummyOidGenerator;

public class ObjectPersistorTest
extends TestCase {
    private ObjectStorePersistor persistor;
    private TestSpecification objectSpecification;
    private MockObjectStore objectStore;
    private TestProxyNakedObject testNakedObject;
    private TestProxySystem system;

    public static void main(String[] args) {
        TestRunner.run(ObjectPersistorTest.class);
    }

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.system = new TestProxySystem();
        this.persistor = new ObjectStorePersistor();
        this.objectStore = new MockObjectStore();
        this.persistor.setObjectStore((NakedObjectStore)this.objectStore);
        this.persistor.setServices(new Object[0]);
        this.persistor.setPersistAlgorithm((PersistAlgorithm)new DummyPersistAlgorithm());
        this.persistor.setOidGenerator((OidGenerator)new DummyOidGenerator());
        this.system.setObjectPersistor((NakedObjectPersistor)this.persistor);
        this.system.init();
        this.testNakedObject = this.system.createPersistentTestObject();
        this.objectSpecification = new TestSpecification();
        this.testNakedObject.setupSpecification((NakedObjectSpecification)this.objectSpecification);
        this.objectStore.reset();
    }

    protected void tearDown() throws Exception {
        this.system.shutdown();
    }

    public void testAbort() {
        this.persistor.startTransaction();
        this.persistor.destroyObject((NakedObject)this.testNakedObject);
        this.persistor.abortTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, "destroyObject " + this.testNakedObject);
        this.objectStore.assertAction(2, "abortTransaction");
        this.objectStore.assertLastAction(2);
    }

    public void testEndTransaction() {
        this.persistor.startTransaction();
        this.persistor.destroyObject((NakedObject)this.testNakedObject);
        this.persistor.endTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, "destroyObject " + this.testNakedObject);
        this.objectStore.assertAction(2, "endTransaction");
        this.objectStore.assertAction(3, "run DestroyObjectCommand " + this.testNakedObject);
    }

    public void testDestroy() {
        this.objectSpecification.fields = new NakedObjectField[0];
        this.persistor.startTransaction();
        this.persistor.destroyObject((NakedObject)this.testNakedObject);
        this.persistor.endTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, "destroyObject " + this.testNakedObject);
        this.objectStore.assertAction(2, "endTransaction");
        this.objectStore.assertAction(3, "run DestroyObjectCommand " + this.testNakedObject);
        ObjectPersistorTest.assertEquals((int)4, (int)this.objectStore.getActions().size());
    }

    public void testMakePersistent() {
        this.objectSpecification.fields = new NakedObjectField[0];
        this.testNakedObject.setupResolveState(ResolveState.TRANSIENT);
        this.persistor.startTransaction();
        this.persistor.makePersistent((NakedObject)this.testNakedObject);
        this.persistor.endTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, "createObject " + this.testNakedObject);
        this.objectStore.assertAction(2, "endTransaction");
        this.objectStore.assertAction(3, "run CreateObjectCommand " + this.testNakedObject);
        ObjectPersistorTest.assertEquals((int)4, (int)this.objectStore.getActions().size());
    }
}

