/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore.inmemory;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.persist.TitleCriteria;
import org.nakedobjects.nof.persist.objectstore.inmemory.MemoryObjectStore;
import org.nakedobjects.nof.testsystem.ProxyTestCase;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySpecification;

public class EmptyMemoryObjectStoreTest
extends ProxyTestCase {
    private MemoryObjectStore store;

    protected void setUp() throws Exception {
        super.setUp();
        this.store = new MemoryObjectStore();
    }

    protected void tearDown() throws Exception {
        this.store.shutdown();
        super.tearDown();
    }

    public void testStartsUpInUnitializedSate() throws Exception {
        EmptyMemoryObjectStoreTest.assertFalse((boolean)this.store.isInitialized());
    }

    public void testFindNoInstances() throws Exception {
        TestProxySpecification spec = this.system.getSpecification(TestPojo.class);
        NakedObject[] instances = this.store.getInstances((InstancesCriteria)new TitleCriteria((NakedObjectSpecification)spec, "title", false));
        EmptyMemoryObjectStoreTest.assertEquals((int)0, (int)instances.length);
    }

    public void testHasNoInstances() throws Exception {
        TestProxySpecification spec = this.system.getSpecification(TestPojo.class);
        EmptyMemoryObjectStoreTest.assertFalse((boolean)this.store.hasInstances((NakedObjectSpecification)spec, false));
    }

    public void testCantFindObjectByOid() {
        TestProxySpecification spec = this.system.getSpecification(TestPojo.class);
        TestProxyOid oid = new TestProxyOid(10, true);
        try {
            this.store.getObject((Oid)oid, (NakedObjectSpecification)spec);
            EmptyMemoryObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testName() throws Exception {
        EmptyMemoryObjectStoreTest.assertEquals((String)"In-Memory Object Store", (String)this.store.name());
    }

    public void testOidForService() throws Exception {
        Oid oidForService = this.store.getOidForService("service name");
        EmptyMemoryObjectStoreTest.assertEquals(null, (Object)oidForService);
    }
}

