/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore.inmemory;

import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.SerialNumberVersion;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.persist.objectstore.inmemory.AllCriteria;
import org.nakedobjects.nof.persist.objectstore.inmemory.TestCriteria;
import org.nakedobjects.nof.persist.objectstore.inmemory.TransientObjectStore;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySpecification;
import org.nakedobjects.nof.testsystem.TestProxySystem;
import org.nakedobjects.testing.TestSpecification;

public class TransientObjectStoreTest
extends TestCase {
    private int nextId;
    private TestProxySpecification objectSpec;
    private TransientObjectStore objectStore;
    private TestProxySpecification superClassObjectSpec;
    private NakedObject object1;
    private NakedObject object2;
    private NakedObject object3;
    private NakedObject object4;
    private NakedObject object5;
    private TestProxySpecification superSuperClassObjectSpec;
    private TestProxySystem system;

    private void assertEquals(NakedObject object, NakedObject v) {
        TransientObjectStoreTest.assertEquals((Object)object.getObject(), (Object)v.getObject());
        TransientObjectStoreTest.assertEquals((Object)object.getOid(), (Object)v.getOid());
    }

    private NakedObject createTestObject() {
        TestProxyNakedObject nakedObject = new TestProxyNakedObject();
        TestProxyOid oid = new TestProxyOid(this.nextId++, true);
        nakedObject.setupOid((Oid)oid);
        nakedObject.setupSpecification((NakedObjectSpecification)this.objectSpec);
        nakedObject.setupObject((Object)new TestPojo());
        return nakedObject;
    }

    private NakedObject createTestSuperClassObject() {
        TestProxyNakedObject nakedObject = new TestProxyNakedObject();
        TestProxyOid oid = new TestProxyOid(this.nextId++, true);
        nakedObject.setupOid((Oid)oid);
        nakedObject.setupSpecification((NakedObjectSpecification)this.superClassObjectSpec);
        nakedObject.setupObject((Object)new TestPojo());
        return nakedObject;
    }

    protected void setUp() throws Exception {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.OFF);
        this.system = new TestProxySystem();
        this.system.init();
        this.superSuperClassObjectSpec = new TestProxySpecification(TestPojo.class);
        this.superClassObjectSpec = new TestProxySpecification(TestPojo.class);
        this.objectSpec = new TestProxySpecification(TestPojo.class);
        this.superClassObjectSpec.setupSubclasses(new NakedObjectSpecification[]{this.objectSpec});
        this.superSuperClassObjectSpec.setupSubclasses(new NakedObjectSpecification[]{this.superClassObjectSpec});
        this.objectStore = new TransientObjectStore();
        this.objectStore.init();
        this.object1 = this.createTestObject();
        this.object2 = this.createTestObject();
        this.object3 = this.createTestSuperClassObject();
        this.object4 = this.createTestSuperClassObject();
        this.object5 = this.createTestObject();
        PersistenceCommand[] commands = new PersistenceCommand[]{this.objectStore.createCreateObjectCommand(this.object1), this.objectStore.createCreateObjectCommand(this.object2), this.objectStore.createCreateObjectCommand(this.object3), this.objectStore.createCreateObjectCommand(this.object4), this.objectStore.createCreateObjectCommand(this.object5)};
        this.objectStore.startTransaction();
        this.objectStore.execute(commands);
        this.objectStore.endTransaction();
        this.system.resetLoader();
    }

    protected void tearDown() throws Exception {
        this.objectStore.shutdown();
    }

    public void testCreateInstances() throws Exception {
        TransientObjectStoreTest.assertEquals((int)3, (int)this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.objectSpec, false)).length);
    }

    public void testDestroyObject() throws Exception {
        PersistenceCommand[] commands = new PersistenceCommand[]{this.objectStore.createDestroyObjectCommand(this.object1)};
        this.objectStore.execute(commands);
        NakedObject[] instances = this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.objectSpec, false));
        TransientObjectStoreTest.assertEquals((int)2, (int)instances.length);
        this.assertEquals(this.object2, instances[0]);
        this.assertEquals(this.object5, instances[1]);
    }

    public void testGetInstancesByCriteria() throws Exception {
        TestCriteria criteria = new TestCriteria((NakedObjectSpecification)this.superClassObjectSpec, false);
        criteria.addMatch(this.object1);
        criteria.addMatch(this.object3);
        NakedObject[] instances = this.objectStore.getInstances((InstancesCriteria)criteria);
        TransientObjectStoreTest.assertEquals((int)1, (int)instances.length);
        this.assertEquals(this.object3, instances[0]);
    }

    public void testGetInstancesByCriteriaIncludingSubclasses() throws Exception {
        TestCriteria criteria = new TestCriteria((NakedObjectSpecification)this.superClassObjectSpec, true);
        criteria.addMatch(this.object1);
        criteria.addMatch(this.object3);
        NakedObject[] instances = this.objectStore.getInstances((InstancesCriteria)criteria);
        TransientObjectStoreTest.assertEquals((int)2, (int)instances.length);
        this.assertEquals(this.object3, instances[0]);
        this.assertEquals(this.object1, instances[1]);
    }

    public void testGetInstancesBySpecification() throws Exception {
        NakedObject[] instances = this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.superClassObjectSpec, false));
        TransientObjectStoreTest.assertEquals((int)2, (int)instances.length);
        this.assertEquals(this.object3, instances[0]);
        this.assertEquals(this.object4, instances[1]);
    }

    public void testGetInstancesBySpecificationIncludingSubclasses() throws Exception {
        NakedObject[] instances = this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.superClassObjectSpec, true));
        TransientObjectStoreTest.assertEquals((int)5, (int)instances.length);
        this.assertEquals(this.object3, instances[0]);
        this.assertEquals(this.object4, instances[1]);
        this.assertEquals(this.object1, instances[2]);
        this.assertEquals(this.object2, instances[3]);
        this.assertEquals(this.object5, instances[4]);
    }

    public void testGetObject() throws Exception {
        this.assertEquals(this.object1, this.objectStore.getObject(this.object1.getOid(), (NakedObjectSpecification)this.objectSpec));
        this.assertEquals(this.object3, this.objectStore.getObject(this.object3.getOid(), (NakedObjectSpecification)this.superClassObjectSpec));
    }

    public void testGetObjectCantFindObject() throws Exception {
        try {
            this.objectStore.getObject((Oid)new TestProxyOid(-3, true), (NakedObjectSpecification)this.objectSpec);
            TransientObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testHasInstances() throws Exception {
        TransientObjectStoreTest.assertTrue((boolean)this.objectStore.hasInstances((NakedObjectSpecification)this.superClassObjectSpec, false));
    }

    public void testHasInstancesIncludingSubclasses() throws Exception {
        TransientObjectStoreTest.assertTrue((boolean)this.objectStore.hasInstances((NakedObjectSpecification)this.superSuperClassObjectSpec, true));
    }

    public void testHasNoInstances() throws Exception {
        TestSpecification spec = new TestSpecification();
        TransientObjectStoreTest.assertFalse((boolean)this.objectStore.hasInstances((NakedObjectSpecification)spec, false));
    }

    public void testHasNoInstancesIncludingSubclasses() throws Exception {
        TestSpecification spec = new TestSpecification();
        TestSpecification superSpec = new TestSpecification();
        superSpec.setupSubclasses(new NakedObjectSpecification[]{spec});
        TransientObjectStoreTest.assertFalse((boolean)this.objectStore.hasInstances((NakedObjectSpecification)superSpec, true));
    }

    public void testNumberOfInstancesIncludingSubclasses() throws Exception {
        TransientObjectStoreTest.assertEquals((int)5, (int)this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.superClassObjectSpec, true)).length);
    }

    public void testShutdown() throws Exception {
        this.objectStore.shutdown();
        TransientObjectStoreTest.assertEquals((int)0, (int)this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.superClassObjectSpec, false)).length);
        TransientObjectStoreTest.assertEquals((int)0, (int)this.objectStore.getInstances((InstancesCriteria)new AllCriteria((NakedObjectSpecification)this.objectSpec, false)).length);
    }

    public void testVersionOfRetrievedObject() throws Exception {
        NakedObject obj = this.objectStore.getObject(this.object1.getOid(), null);
        TransientObjectStoreTest.assertSame((Object)this.object1.getObject(), (Object)obj.getObject());
        TransientObjectStoreTest.assertEquals((long)1L, (long)((SerialNumberVersion)obj.getVersion()).getSequence());
        TransientObjectStoreTest.assertEquals((String)"user", (String)obj.getVersion().getUser());
    }

    public void testVersionOfNewObject() throws Exception {
        TransientObjectStoreTest.assertEquals((String)"user", (String)this.object1.getVersion().getUser());
        TransientObjectStoreTest.assertEquals((long)1L, (long)((SerialNumberVersion)this.object1.getVersion()).getSequence());
    }

    public void testVersionOfSavedObject() throws Exception {
        SaveObjectCommand saveCommand = this.objectStore.createSaveObjectCommand(this.object1);
        this.objectStore.execute(new PersistenceCommand[]{saveCommand});
        TransientObjectStoreTest.assertEquals((String)"user", (String)this.object1.getVersion().getUser());
        TransientObjectStoreTest.assertEquals((long)2L, (long)((SerialNumberVersion)this.object1.getVersion()).getSequence());
    }

    public void testDebug() {
        DebugString dtr = new DebugString();
        this.objectStore.debugData(dtr);
        TransientObjectStoreTest.assertTrue((dtr.toString().length() > 0 ? 1 : 0) != 0);
    }

    public void testSave() {
        ((TestProxyNakedObject)this.object3).setupTitleString("title");
        Version version = this.object3.getVersion();
        PersistenceCommand[] commands = new PersistenceCommand[]{this.objectStore.createSaveObjectCommand(this.object3)};
        this.objectStore.startTransaction();
        this.objectStore.execute(commands);
        this.objectStore.endTransaction();
        TransientObjectStoreTest.assertNotSame((Object)version, (Object)this.object3.getVersion());
    }
}

