/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.NotPersistableException;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nof.core.util.UnknownTypeException;
import org.nakedobjects.nof.persist.PersistAlgorithm;
import org.nakedobjects.nof.persist.PersistedObjectAdder;

public class DefaultPersistAlgorithm
implements PersistAlgorithm {
    private static final Logger LOG = Logger.getLogger(DefaultPersistAlgorithm.class);

    public void init() {
    }

    public void makePersistent(NakedObject object, PersistedObjectAdder persistor) {
        if (object.getResolveState().isPersistent() || object.persistable() == Persistable.TRANSIENT) {
            throw new NotPersistableException("can't make object persistent - either already persistent, or transient only: " + object);
        }
        this.persist(object, persistor);
    }

    private void persist(NakedObject object, PersistedObjectAdder persistor) {
        if (object.getResolveState().isTransient() && object.persistable() != Persistable.TRANSIENT) {
            LOG.info((Object)("make persistent " + object));
            object.getSpecification().lifecycleEvent(object, 1);
            NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)object);
            NakedObjectField[] fields = object.getSpecification().getFields();
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectField field = fields[i];
                if (!field.isPersisted() || field.isValue()) continue;
                if (field instanceof OneToManyAssociation) {
                    NakedCollection collection = (NakedCollection)field.get(object);
                    if (collection == null) {
                        throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullName());
                    }
                    this.makePersistent(collection, persistor);
                    continue;
                }
                Naked fieldValue = field.get(object);
                if (fieldValue == null) continue;
                if (!(fieldValue instanceof NakedObject)) {
                    throw new UnknownTypeException(fieldValue + " is not a NakedObject");
                }
                this.persist((NakedObject)fieldValue, persistor);
            }
            persistor.addPersistedObject(object);
            object.getSpecification().lifecycleEvent(object, 2);
        }
    }

    protected void makePersistent(NakedCollection collection, PersistedObjectAdder persistor) {
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.GHOST) {
            collection.changeState(ResolveState.RESOLVING);
            collection.changeState(ResolveState.RESOLVED);
        } else if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        Enumeration elements = collection.elements();
        while (elements.hasMoreElements()) {
            this.persist((NakedObject)elements.nextElement(), persistor);
        }
    }

    public String name() {
        return "Simple Bottom Up Persistence Walker";
    }

    public void shutdown() {
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

