/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.conf.ConfigurationException;
import org.nakedobjects.nof.core.system.InstanceCreationException;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.Logger;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;

public class ObjectStoreLogger
extends Logger
implements NakedObjectStore {
    private final NakedObjectStore decorated;

    public ObjectStoreLogger(NakedObjectStore decorated, String logFileName) {
        super(logFileName, false);
        this.decorated = decorated;
    }

    public ObjectStoreLogger(NakedObjectStore decorated) {
        super(null, true);
        this.decorated = decorated;
    }

    public void abortTransaction() throws ObjectPersistenceException {
        this.log("Abort transaction started");
        this.decorated.abortTransaction();
        this.log("Abort transaction complete");
    }

    public CreateObjectCommand createCreateObjectCommand(NakedObject object) {
        this.log("Create object " + object);
        return this.decorated.createCreateObjectCommand(object);
    }

    public void registerService(String name, Oid oid) {
        this.log("register service " + name + " as " + oid);
        this.decorated.registerService(name, oid);
    }

    public DestroyObjectCommand createDestroyObjectCommand(NakedObject object) {
        this.log("Destroy object " + object);
        return this.decorated.createDestroyObjectCommand(object);
    }

    public SaveObjectCommand createSaveObjectCommand(NakedObject object) {
        this.log("Save object " + object);
        return this.decorated.createSaveObjectCommand(object);
    }

    public void endTransaction() throws ObjectPersistenceException {
        this.log("End transaction");
        this.decorated.endTransaction();
    }

    public void debugData(DebugString debug) {
        this.decorated.debugData(debug);
    }

    public String debugTitle() {
        return this.decorated.debugTitle();
    }

    protected Class getDecoratedClass() {
        return this.decorated.getClass();
    }

    public NakedObject[] getInstances(InstancesCriteria criteria) throws ObjectPersistenceException, UnsupportedFindException {
        this.log("Get instances matching " + criteria);
        return this.decorated.getInstances(criteria);
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        NakedObject object = this.decorated.getObject(oid, hint);
        this.log("Get object for " + oid + " (of type " + hint.getShortName() + ")", object.getObject());
        return object;
    }

    public Oid getOidForService(String name) {
        Oid oid = this.decorated.getOidForService(name);
        this.log("Get OID for service " + name + ": " + oid);
        return oid;
    }

    public boolean hasInstances(NakedObjectSpecification specification, boolean includeSubclasses) throws ObjectPersistenceException {
        boolean hasInstances = this.decorated.hasInstances(specification, includeSubclasses);
        this.log("Has instances of " + specification.getShortName(), "" + hasInstances);
        return hasInstances;
    }

    public boolean isInitialized() {
        boolean isInitialized = this.decorated.isInitialized();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    public void init() throws ConfigurationException, InstanceCreationException, ObjectPersistenceException {
        this.log("Initialising " + this.name());
        this.decorated.init();
    }

    public String name() {
        return this.decorated.name();
    }

    public void reset() {
        this.log("Reset");
        this.decorated.reset();
    }

    public void resolveField(NakedObject object, NakedObjectField field) throws ObjectPersistenceException {
        this.log("Resolve eagerly object in field " + field + " of " + object);
        this.decorated.resolveField(object, field);
    }

    public void resolveImmediately(NakedObject object) throws ObjectPersistenceException {
        this.log("Resolve immediately: " + object);
        this.decorated.resolveImmediately(object);
    }

    public void execute(PersistenceCommand[] commands) throws ObjectPersistenceException {
        this.log("Run transactions");
        for (int i = 0; i < commands.length; ++i) {
            this.log("  " + i + " " + commands[i]);
        }
        this.decorated.execute(commands);
    }

    public boolean flush(PersistenceCommand[] commands) throws ObjectPersistenceException {
        this.log("flush transactions");
        for (int i = 0; i < commands.length; ++i) {
            this.log("  " + i + " " + commands[i]);
        }
        return this.decorated.flush(commands);
    }

    public void shutdown() throws ObjectPersistenceException {
        this.log("Shutting down " + this.decorated);
        this.decorated.shutdown();
        this.close();
    }

    public void startTransaction() throws ObjectPersistenceException {
        this.log("Start transaction");
        this.decorated.startTransaction();
    }
}

