/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore.inmemory;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Debug;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.objectstore.inmemory.MemoryObjectStoreInstances;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.ExecutionContext;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;

public class MemoryObjectStore
implements NakedObjectStore {
    private static final Logger LOG = Logger.getLogger(MemoryObjectStore.class);
    protected final Hashtable instances;
    protected final Hashtable services;

    public MemoryObjectStore() {
        LOG.info((Object)"creating object store");
        this.instances = new Hashtable();
        this.services = new Hashtable();
    }

    public void abortTransaction() {
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        return new CreateObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
                LOG.debug((Object)("  create object " + object));
                MemoryObjectStore.this.save(object);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "CreateObjectCommand [object=" + object + "]";
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        return new DestroyObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
                LOG.info((Object)("  delete object '" + object + "'"));
                MemoryObjectStore.this.destroy(object);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "DestroyObjectCommand [object=" + object + "]";
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(final NakedObject object) {
        return new SaveObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
                MemoryObjectStore.this.save(object);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "SaveObjectCommand [object=" + object + "]";
            }
        };
    }

    private String debugCollectionGraph(NakedCollection collection, int level, Vector recursiveElements) {
        StringBuffer s = new StringBuffer();
        if (recursiveElements.contains(collection)) {
            s.append("*\n");
        } else {
            recursiveElements.addElement(collection);
            Enumeration e = collection.elements();
            while (e.hasMoreElements()) {
                NakedObject element;
                this.indent(s, level);
                try {
                    element = (NakedObject)e.nextElement();
                }
                catch (ClassCastException ex) {
                    LOG.error((Object)ex);
                    return s.toString();
                }
                s.append(element);
                s.append(this.debugGraph(element, level + 1, recursiveElements));
            }
        }
        return s.toString();
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Business Objects");
        Enumeration e = this.instances.keys();
        while (e.hasMoreElements()) {
            NakedObjectSpecification spec = (NakedObjectSpecification)e.nextElement();
            debug.appendln(spec.getFullName());
            MemoryObjectStoreInstances instances = this.instancesFor(spec);
            Enumeration f = instances.elements();
            debug.indent();
            if (!f.hasMoreElements()) {
                debug.appendln("no instances");
            }
            while (f.hasMoreElements()) {
                debug.appendln(f.nextElement().toString());
            }
            debug.appendln();
            debug.unindent();
        }
        debug.unindent();
        debug.appendln();
        debug.appendTitle("Object graphs");
        Vector dump = new Vector();
        e = this.instances.keys();
        while (e.hasMoreElements()) {
            NakedObjectSpecification spec = (NakedObjectSpecification)e.nextElement();
            MemoryObjectStoreInstances instances = this.instancesFor(spec);
            Enumeration f = instances.elements();
            while (f.hasMoreElements()) {
                NakedObject object = (NakedObject)f.nextElement();
                debug.append((Object)spec.getFullName());
                debug.append((Object)": ");
                debug.append((Object)object);
                debug.appendln(this.debugGraph(object, 0, dump));
            }
        }
    }

    private String debugGraph(NakedObject object, int level, Vector recursiveElements) {
        if (level > 3) {
            return "...\n";
        }
        Vector elements = recursiveElements == null ? new Vector(25, 10) : recursiveElements;
        if (object instanceof NakedCollection) {
            return "\n" + this.debugCollectionGraph((NakedCollection)object, level, elements);
        }
        return "\n" + this.debugObjectGraph(object, level, elements);
    }

    private String debugObjectGraph(NakedObject object, int level, Vector recursiveElements) {
        StringBuffer s = new StringBuffer();
        recursiveElements.addElement(object);
        NakedObjectField[] fields = object.getSpecification().getFields();
        for (int i = 0; i < fields.length; ++i) {
            NakedObjectField field = fields[i];
            Naked obj = field.get(object);
            String id = field.getId();
            this.indent(s, level);
            if (field.isCollection()) {
                s.append(id + ": \n" + this.debugCollectionGraph((NakedCollection)obj, level + 1, recursiveElements));
                continue;
            }
            if (obj instanceof NakedObject) {
                if (recursiveElements.contains(obj)) {
                    s.append(id + ": " + obj + "*\n");
                    continue;
                }
                s.append(id + ": " + obj);
                s.append(this.debugGraph((NakedObject)obj, level + 1, recursiveElements));
                continue;
            }
            s.append(id + ": " + obj);
            s.append("\n");
        }
        return s.toString();
    }

    public String debugTitle() {
        return this.name();
    }

    private void destroy(NakedObject object) {
        NakedObjectSpecification specification = object.getSpecification();
        LOG.debug((Object)("   destroy object " + object + " as instance of " + specification.getShortName()));
        MemoryObjectStoreInstances ins = this.instancesFor(specification);
        ins.remove(object.getOid());
    }

    public void endTransaction() {
    }

    public void execute(PersistenceCommand[] commands) throws ObjectPersistenceException {
        LOG.info((Object)"start execution of transaction ");
        for (int i = 0; i < commands.length; ++i) {
            commands[i].execute(null);
        }
        LOG.info((Object)"end execution");
    }

    public NakedObject[] getInstances(InstancesCriteria criteria) throws ObjectPersistenceException, UnsupportedFindException {
        Vector instances = new Vector();
        NakedObjectSpecification spec = criteria.getSpecification();
        this.getInstances(spec, criteria, instances, criteria.includeSubclasses());
        return this.toInstancesArray(instances);
    }

    private void getInstances(NakedObjectSpecification spec, InstancesCriteria criteria, Vector instances, boolean includeSubclasses) {
        this.instancesFor(spec).instances(criteria, instances);
        if (includeSubclasses) {
            NakedObjectSpecification[] subclasses = spec.subclasses();
            for (int i = 0; i < subclasses.length; ++i) {
                this.getInstances(subclasses[i], criteria, instances, includeSubclasses);
            }
        }
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        LOG.debug((Object)("getObject " + oid));
        MemoryObjectStoreInstances ins = this.instancesFor(hint);
        NakedObject object = ins.getObject(oid);
        if (object == null) {
            throw new ObjectNotFoundException((Object)oid);
        }
        this.setupReferencedObjects(object);
        return object;
    }

    public Oid getOidForService(String name) {
        return (Oid)this.services.get(name);
    }

    public boolean hasInstances(NakedObjectSpecification spec, boolean includeSubclasses) {
        if (this.instancesFor(spec).hasInstances()) {
            return true;
        }
        if (includeSubclasses) {
            NakedObjectSpecification[] subclasses = spec.subclasses();
            for (int i = 0; i < subclasses.length; ++i) {
                if (!this.hasInstances(subclasses[i], includeSubclasses)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        return false;
    }

    private void indent(StringBuffer s, int level) {
        for (int indent = 0; indent < level; ++indent) {
            s.append(Debug.indentString((int)4) + "|");
        }
        s.append(Debug.indentString((int)4) + "+--");
    }

    public void init() {
    }

    private MemoryObjectStoreInstances instancesFor(NakedObjectSpecification spec) {
        MemoryObjectStoreInstances ins = (MemoryObjectStoreInstances)this.instances.get(spec);
        if (ins == null) {
            ins = new MemoryObjectStoreInstances(NakedObjectsContext.getObjectLoader());
            this.instances.put(spec, ins);
        }
        return ins;
    }

    public String name() {
        return "In-Memory Object Store";
    }

    public void registerService(String name, Oid oid) {
        if (this.services.containsKey(name)) {
            throw new NakedObjectRuntimeException("Service already registered: " + name);
        }
        this.services.put(name, oid);
    }

    public void reset() {
    }

    public void resolveField(NakedObject object, NakedObjectField field) throws ObjectPersistenceException {
        NakedReference reference = (NakedReference)field.get(object);
        NakedObjectsContext.getObjectLoader().start(reference, ResolveState.RESOLVING);
        NakedObjectsContext.getObjectLoader().end(reference);
    }

    public void resolveImmediately(NakedObject object) throws ObjectPersistenceException {
        LOG.debug((Object)("resolve " + object));
        this.setupReferencedObjects(object);
        NakedObjectsContext.getObjectLoader().start((NakedReference)object, ResolveState.RESOLVING);
        NakedObjectsContext.getObjectLoader().end((NakedReference)object);
    }

    private void save(NakedObject object) throws ObjectPersistenceException {
        NakedObjectSpecification specification = object.getSpecification();
        LOG.debug((Object)("   saving object " + object + " as instance of " + specification.getShortName()));
        MemoryObjectStoreInstances ins = this.instancesFor(specification);
        ins.save(object);
    }

    private void setupReferencedObjects(NakedObject object) {
        this.setupReferencedObjects(object, new Vector());
    }

    private void setupReferencedObjects(NakedObject object, Vector all) {
    }

    public void shutdown() {
        LOG.info((Object)("shutdown " + this));
        Enumeration e = this.instances.elements();
        while (e.hasMoreElements()) {
            MemoryObjectStoreInstances inst = (MemoryObjectStoreInstances)e.nextElement();
            inst.shutdown();
        }
        this.instances.clear();
    }

    public void startTransaction() {
    }

    private NakedObject[] toInstancesArray(Vector instances) {
        NakedObject[] ins = new NakedObject[instances.size()];
        for (int i = 0; i < ins.length; ++i) {
            NakedObject object = (NakedObject)instances.elementAt(i);
            this.setupReferencedObjects(object);
            if (object.getResolveState().isResolvable(ResolveState.RESOLVING)) {
                NakedObjectsContext.getObjectLoader().start((NakedReference)object, ResolveState.RESOLVING);
                NakedObjectsContext.getObjectLoader().end((NakedReference)object);
            }
            ins[i] = object;
        }
        return ins;
    }

    public boolean flush(PersistenceCommand[] commands) {
        return false;
    }
}

