/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore.inmemory;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.SerialNumberVersion;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.Dump;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.objectstore.inmemory.TransientObjectStoreInstances;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.ExecutionContext;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;

public class TransientObjectStore
implements NakedObjectStore {
    private static final Logger LOG = Logger.getLogger(TransientObjectStore.class);
    private final Hashtable oidObjectMap;
    private final Hashtable instances;
    private final Hashtable oidServiceMap;

    public TransientObjectStore() {
        LOG.debug((Object)("creating " + this));
        this.instances = new Hashtable();
        this.oidObjectMap = new Hashtable();
        this.oidServiceMap = new Hashtable();
    }

    public void abortTransaction() {
        LOG.debug((Object)"transaction aborted");
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        return new CreateObjectCommand(){

            public void execute(ExecutionContext context) {
                LOG.info((Object)("  create object " + object));
                NakedObjectSpecification specification = object.getSpecification();
                LOG.debug((Object)("   saving object " + object + " as instance of " + specification.getFullName()));
                TransientObjectStoreInstances ins = TransientObjectStore.this.instancesFor(specification);
                ins.add(object);
                TransientObjectStore.this.oidObjectMap.put(object.getOid(), object);
                object.setOptimisticLock((Version)new SerialNumberVersion(1L, "user", new Date()));
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "CreateObjectCommand [object=" + object + "]";
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        return new DestroyObjectCommand(){

            public void execute(ExecutionContext context) {
                LOG.info((Object)("  delete object '" + object + "'"));
                TransientObjectStore.this.oidObjectMap.remove(object.getOid());
                NakedObjectSpecification specification = object.getSpecification();
                LOG.debug((Object)("   destroy object " + object + " as instance of " + specification.getFullName()));
                TransientObjectStoreInstances ins = TransientObjectStore.this.instancesFor(specification);
                ins.remove(object);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "DestroyObjectCommand [object=" + object + "]";
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(final NakedObject object) {
        return new SaveObjectCommand(){

            public void execute(ExecutionContext context) {
                NakedObjectSpecification specification = object.getSpecification();
                LOG.info((Object)("   saving object " + object + " as instance of " + specification.getFullName()));
                Version version = object.getVersion();
                SerialNumberVersion serialNumberVersion = (SerialNumberVersion)version;
                Version next = serialNumberVersion.next("user", new Date());
                object.setOptimisticLock(next);
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return "SaveObjectCommand [object=" + object + "]";
            }
        };
    }

    public void endTransaction() {
        LOG.debug((Object)"end transaction");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)"finalizing object store");
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Business Objects");
        Enumeration e = this.instances.keys();
        while (e.hasMoreElements()) {
            NakedObjectSpecification spec = (NakedObjectSpecification)e.nextElement();
            debug.appendln(spec.getFullName());
            TransientObjectStoreInstances instances = this.instancesFor(spec);
            Vector v = new Vector();
            instances.instances(v);
            Enumeration f = v.elements();
            debug.indent();
            if (!f.hasMoreElements()) {
                debug.appendln("no instances");
            } else {
                while (f.hasMoreElements()) {
                    debug.appendln("" + f.nextElement());
                }
            }
            debug.appendln();
            debug.unindent();
        }
        debug.appendln();
        debug.appendTitle("Service Objects");
        e = this.oidServiceMap.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            debug.appendln(this.oidServiceMap.get(name) + " -> " + name);
        }
        debug.appendln();
        debug.appendTitle("Object graphs");
        Vector dump = new Vector();
        e = this.instances.keys();
        while (e.hasMoreElements()) {
            NakedObjectSpecification spec = (NakedObjectSpecification)e.nextElement();
            TransientObjectStoreInstances instances = this.instancesFor(spec);
            Vector v = new Vector();
            instances.instances(v);
            Enumeration f = v.elements();
            while (f.hasMoreElements()) {
                debug.append((Object)spec.getFullName());
                debug.append((Object)": ");
                NakedObject object = (NakedObject)f.nextElement();
                debug.appendln(Dump.graph((Naked)object, dump));
            }
        }
    }

    public String debugTitle() {
        return this.name();
    }

    public NakedObject[] getInstances(InstancesCriteria criteria) {
        Vector allInstances = new Vector();
        this.getInstances(criteria, allInstances);
        NakedObject[] matchedInstances = new NakedObject[allInstances.size()];
        int matches = 0;
        for (int i = 0; i < allInstances.size(); ++i) {
            NakedObject object = (NakedObject)allInstances.elementAt(i);
            if (!criteria.matches(object)) continue;
            matchedInstances[matches++] = object;
        }
        NakedObject[] ins = new NakedObject[matches];
        System.arraycopy(matchedInstances, 0, ins, 0, matches);
        return ins;
    }

    private void getInstances(InstancesCriteria criteria, Vector instances) {
        NakedObjectSpecification spec = criteria.getSpecification();
        this.instancesFor(spec).instances(instances);
        if (criteria.includeSubclasses()) {
            NakedObjectSpecification[] subclasses = spec.subclasses();
            for (int i = 0; i < subclasses.length; ++i) {
                this.getInstances(subclasses[i], instances, criteria.includeSubclasses());
            }
        }
    }

    private void getInstances(NakedObjectSpecification spec, Vector instances, boolean includeSubclasses) {
        this.instancesFor(spec).instances(instances);
        if (includeSubclasses) {
            NakedObjectSpecification[] subclasses = spec.subclasses();
            for (int i = 0; i < subclasses.length; ++i) {
                this.getInstances(subclasses[i], instances, includeSubclasses);
            }
        }
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) {
        LOG.debug((Object)("getObject " + oid));
        NakedObject nakedObject = (NakedObject)this.oidObjectMap.get(oid);
        if (nakedObject == null) {
            throw new ObjectNotFoundException((Object)oid);
        }
        return nakedObject;
    }

    public Oid getOidForService(String name) {
        return (Oid)this.oidServiceMap.get(name);
    }

    public boolean hasInstances(NakedObjectSpecification spec, boolean includeSubclasses) {
        if (this.instancesFor(spec).hasInstances()) {
            return true;
        }
        if (includeSubclasses) {
            NakedObjectSpecification[] subclasses = spec.subclasses();
            for (int i = 0; i < subclasses.length; ++i) {
                if (!this.hasInstances(subclasses[i], includeSubclasses)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        return false;
    }

    public void init() {
        LOG.debug((Object)("initialising " + this));
    }

    private TransientObjectStoreInstances instancesFor(NakedObjectSpecification spec) {
        TransientObjectStoreInstances ins = (TransientObjectStoreInstances)this.instances.get(spec);
        if (ins == null) {
            ins = new TransientObjectStoreInstances();
            this.instances.put(spec, ins);
        }
        return ins;
    }

    public String name() {
        return "Transient Object Store";
    }

    public void resolveField(NakedObject object, NakedObjectField field) {
        if (!field.isCollection()) {
            throw new UnexpectedCallException();
        }
        NakedCollection collection = (NakedCollection)field.get(object);
        NakedObjectsContext.getObjectLoader().start((NakedReference)collection, ResolveState.RESOLVING);
        NakedObjectsContext.getObjectLoader().end((NakedReference)collection);
    }

    public void registerService(String name, Oid oid) {
        if (this.oidServiceMap.containsKey(name)) {
            throw new NakedObjectRuntimeException("Service already exists: " + name);
        }
        this.oidServiceMap.put(name, oid);
    }

    public void reset() {
    }

    public void execute(PersistenceCommand[] commands) {
        LOG.info((Object)"start execution of transaction ");
        for (int i = 0; i < commands.length; ++i) {
            commands[i].execute(null);
        }
        LOG.info((Object)"end execution");
    }

    public boolean flush(PersistenceCommand[] commands) {
        LOG.info((Object)"start flush of transaction ");
        for (int i = 0; i < commands.length; ++i) {
            commands[i].execute(null);
        }
        LOG.info((Object)"end flush");
        return commands.length > 0;
    }

    public void resolveImmediately(NakedObject object) {
        LOG.debug((Object)("resolve " + object));
    }

    public void shutdown() {
        LOG.info((Object)("shutting down " + this));
        this.oidObjectMap.clear();
        Enumeration e = this.instances.elements();
        while (e.hasMoreElements()) {
            TransientObjectStoreInstances inst = (TransientObjectStoreInstances)e.nextElement();
            inst.shutdown();
        }
        this.instances.clear();
    }

    public void startTransaction() {
        LOG.debug((Object)"start transaction");
    }
}

