package org.nakedobjects.nof.persist;

import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.nof.core.system.ObjectLoaderInstaller;
import org.nakedobjects.nof.core.system.ObjectPersistorInstaller;

public abstract class AbstractObjectPersistorInstaller implements ObjectPersistorInstaller {

    /**
     * Returns null to indicate that the default object loader should be used, i.e. a specific loader is not required.
     */
    public ObjectLoaderInstaller getPreferredObjectLoaderInstaller() {
        return null;
    }

    /**
     * Empty implementation - do nothing to the reflector.
     */
    public void setUpReflector(NakedObjectReflector reflector) {}
}


// Copyright (c) Naked Objects Group Ltd.
