package org.nakedobjects.nof.persist.objectstore;

import java.util.Vector;

import junit.framework.Assert;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.ExecutionContext;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;


public class MockObjectStore implements NakedObjectStore {
    private Vector actions = new Vector();
    private NakedObjectSpecification expectedClass;
    private NakedObject getObject;
    private int instanceCount;
    private NakedObject[] instances = null;
    private boolean hasInstances;

    public MockObjectStore() {
        super();
    }

    public void assertAction(final int i, final String expected) {
        Assert.assertTrue("invalid action number " + i, actions.size() > i);
        String actual = (String) actions.elementAt(i);

        if (expected == null && actual == null)
            return;
        if (expected != null && actual.startsWith(expected))
            return;
        Assert.fail("action " + i + " expected: <" + expected + "> but was: <" + actual + ">");
    }

    public void assertLastAction(final int expectedLastAction) {
        int actualLastAction = actions.size() - 1;
        Assert.assertEquals(expectedLastAction, actualLastAction);
    }

    public void abortTransaction() {
        actions.addElement("abortTransaction");
    }

    public void setupGetObject(final NakedObject object) {
        getObject = object;
    }

    public void createNakedClass(final NakedObject cls) throws ObjectPersistenceException {}

    public void endTransaction() {
        actions.addElement("endTransaction");
    }

    public Vector getActions() {
        return actions;
    }

    public void debugData(final DebugString debug) {}

    public String debugTitle() {
        return null;
    }

    public NakedObject getObject(final Oid oid, final NakedObjectSpecification hint) throws ObjectNotFoundException,
            ObjectPersistenceException {
        if (getObject == null) {
            Assert.fail("no object expected");
        }
        Assert.assertEquals(getObject.getOid(), oid);
        return getObject;
    }

    public Oid getOidForService(String name) {
        return null;
    }

    public boolean hasInstances(final NakedObjectSpecification cls, final boolean includeSubclasses) {
        return hasInstances;
    }

    public void init() throws ObjectPersistenceException {}

    public boolean isInitialized() {
        return true;
    }

    public String name() {
        return null;
    }

    public void reset() {
        instanceCount = 0;
        actions.removeAllElements();
    }

    public void resolveImmediately(final NakedObject object) {}

    public void resolveField(final NakedObject object, final NakedObjectField field) throws ObjectPersistenceException {}

    public void setupInstancesCount(final int i) {
        instanceCount = i;
    }

    public void setupInstances(final NakedObject[] instances, final NakedObjectSpecification cls) {
        this.instances = instances;
        this.expectedClass = cls;
    }

    public void setupHasInstances(final boolean flag) {
        hasInstances = flag;
    }

    public void shutdown() throws ObjectPersistenceException {}

    public void startTransaction() {
        actions.addElement("startTransaction");
    }

    public NakedObject[] getInstances(final InstancesCriteria criteria) throws ObjectPersistenceException,
            UnsupportedFindException {
        actions.addElement("getInstances " + criteria);
        return instances;
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        actions.addElement("createObject " + object);
        return new CreateObjectCommand() {

            public void execute(final ExecutionContext context) throws ObjectPersistenceException {}

            public String toString() {
                return "CreateObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return null;
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        actions.addElement("destroyObject " + object);
        return new DestroyObjectCommand() {

            public void execute(final ExecutionContext context) throws ObjectPersistenceException {}

            public String toString() {
                return "DestroyObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return object;
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(final NakedObject object) {
        actions.addElement("saveObject " + object);
        return null;
    }

    public void execute(final PersistenceCommand[] commands) throws ObjectPersistenceException {
        for (int i = 0; i < commands.length; i++) {
            actions.addElement("run " + commands[i]);

            commands[i].execute(null);
        }
    }

    public boolean flush(PersistenceCommand[] commands) {
        for (int i = 0; i < commands.length; i++) {
            actions.addElement("flush " + commands[i]);
            commands[i].execute(null);
        }

        return commands.length > 0;
    }

    public void registerService(String name, Oid oid) {}
}
// Copyright (c) Naked Objects Group Ltd.
