package org.nakedobjects.nof.persist.objectstore.inmemory;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.testsystem.ProxyTestCase;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;


public class DebugMemoryObjectStoreTest extends ProxyTestCase {
    private MemoryObjectStore store;

    protected void setUp() throws Exception {
        super.setUp();
        store = new MemoryObjectStore();
    }

    protected void tearDown() throws Exception {
        store.shutdown();
        super.tearDown();
    }

    public void testObject() throws Exception {
        TestProxyNakedObject object = system.createPersistentTestObject();
        object.setupTitleString("title");

        CreateObjectCommand command = store.createCreateObjectCommand(object);
        store.execute(new PersistenceCommand[] { command });

        store.debugTitle();
        DebugString debug = new DebugString();
        store.debugData(debug);
    }
    
    public void testEmpty() throws Exception {
        store.debugTitle();
        DebugString debug = new DebugString();
        store.debugData(debug);
    }
}

// Copyright (c) Naked Objects Group Ltd.
