/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist;

import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.easymock.MockControl;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.NotPersistableException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.persist.DefaultPersistAlgorithm;
import org.nakedobjects.nof.persist.PersistedObjectAdder;
import org.nakedobjects.testing.DummyNakedObject;
import org.nakedobjects.testing.MockContext;
import org.nakedobjects.testing.TestSpecification;

public class DefaultPersistAlgorithmTest
extends TestCase {
    private DefaultPersistAlgorithm algorithm;
    private MockContext context;
    private PersistedObjectAdder adder;
    private MockControl control;
    private DummyNakedObject object;
    private MockControl fieldControl;
    private OneToOneAssociation oneToOneAssociation;
    private DummyNakedObject fieldsObject;

    protected void setUp() throws Exception {
        BasicConfigurator.configure();
        this.algorithm = new DefaultPersistAlgorithm();
        this.context = new MockContext();
        this.context.initObjectLoader();
        this.control = MockControl.createControl(PersistedObjectAdder.class);
        this.adder = (PersistedObjectAdder)this.control.getMock();
        this.object = new DummyNakedObject(ResolveState.TRANSIENT);
        this.fieldControl = MockControl.createControl(OneToOneAssociation.class);
        this.oneToOneAssociation = (OneToOneAssociation)this.fieldControl.getMock();
        TestSpecification spec = new TestSpecification();
        NakedObjectField[] fields = new NakedObjectField[]{this.oneToOneAssociation};
        spec.setupFields(fields);
        this.object.setupSpecification((NakedObjectSpecification)spec);
        this.fieldsObject = new DummyNakedObject(ResolveState.TRANSIENT);
        this.fieldsObject.setupSpecification((NakedObjectSpecification)new TestSpecification());
    }

    public void testMakePersistentFailsIfObjectAlreadyPersistent() {
        this.object.setupResolveState(ResolveState.RESOLVED);
        try {
            this.algorithm.makePersistent((NakedObject)this.object, this.adder);
            DefaultPersistAlgorithmTest.fail();
        }
        catch (NotPersistableException notPersistableException) {
            // empty catch block
        }
    }

    public void testMakePersistentFailsIfObjectMustBeTransient() {
        try {
            this.object.setupPersistable(Persistable.TRANSIENT);
            this.algorithm.makePersistent((NakedObject)this.object, this.adder);
        }
        catch (NotPersistableException notPersistableException) {
            // empty catch block
        }
    }

    public void testMakePersistentRecursesThroughReferenceFields() {
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isPersisted(), (Object)true);
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isValue(), (Object)false);
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.get((NakedObject)this.object), (Object)this.fieldsObject);
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)this.object);
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)this.fieldsObject);
        this.adder.addPersistedObject((NakedObject)this.object);
        this.adder.addPersistedObject((NakedObject)this.fieldsObject);
        this.replay();
        this.algorithm.makePersistent((NakedObject)this.object, this.adder);
        this.verify();
    }

    public void testMakePersistentRecursesThroughReferenceFieldsSkippingNullReferences() {
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isPersisted(), (Object)true);
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isValue(), (Object)false);
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.get((NakedObject)this.object), null);
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)this.object);
        this.adder.addPersistedObject((NakedObject)this.object);
        this.replay();
        this.algorithm.makePersistent((NakedObject)this.object, this.adder);
        this.verify();
    }

    public void testMakePersistentRecursesThroughReferenceFieldsSkippingNonPersistentFields() {
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isPersisted(), (Object)false);
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)this.object);
        this.adder.addPersistedObject((NakedObject)this.object);
        this.replay();
        this.algorithm.makePersistent((NakedObject)this.object, this.adder);
        this.verify();
    }

    public void testMakePersistentRecursesThroughReferenceFieldsSkippingObjectsThatAreAlreadyPersistent() {
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isPersisted(), (Object)true);
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.isValue(), (Object)false);
        this.fieldControl.expectAndReturn((Object)this.oneToOneAssociation.get((NakedObject)this.object), (Object)this.fieldsObject);
        this.fieldsObject.setupResolveState(ResolveState.RESOLVED);
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)this.object);
        this.adder.addPersistedObject((NakedObject)this.object);
        this.replay();
        this.algorithm.makePersistent((NakedObject)this.object, this.adder);
        this.verify();
    }

    private void verify() {
        this.fieldControl.verify();
        this.context.verify();
        this.control.verify();
    }

    private void replay() {
        this.fieldControl.replay();
        this.context.replay();
        this.control.replay();
    }
}

