/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore;

import java.util.Vector;
import junit.framework.Assert;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.ExecutionContext;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;

public class MockObjectStore
implements NakedObjectStore {
    private Vector actions = new Vector();
    private NakedObjectSpecification expectedClass;
    private NakedObject getObject;
    private int instanceCount;
    private NakedObject[] instances = null;
    private boolean hasInstances;

    public void assertAction(int i, String expected) {
        Assert.assertTrue((String)("invalid action number " + i), (this.actions.size() > i ? 1 : 0) != 0);
        String actual = (String)this.actions.elementAt(i);
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && actual.startsWith(expected)) {
            return;
        }
        Assert.fail((String)("action " + i + " expected: <" + expected + "> but was: <" + actual + ">"));
    }

    public void assertLastAction(int expectedLastAction) {
        int actualLastAction = this.actions.size() - 1;
        Assert.assertEquals((int)expectedLastAction, (int)actualLastAction);
    }

    public void abortTransaction() {
        this.actions.addElement("abortTransaction");
    }

    public void setupGetObject(NakedObject object) {
        this.getObject = object;
    }

    public void createNakedClass(NakedObject cls) throws ObjectPersistenceException {
    }

    public void endTransaction() {
        this.actions.addElement("endTransaction");
    }

    public Vector getActions() {
        return this.actions;
    }

    public void debugData(DebugString debug) {
    }

    public String debugTitle() {
        return null;
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        if (this.getObject == null) {
            Assert.fail((String)"no object expected");
        }
        Assert.assertEquals((Object)this.getObject.getOid(), (Object)oid);
        return this.getObject;
    }

    public Oid getOidForService(String name) {
        return null;
    }

    public boolean hasInstances(NakedObjectSpecification cls, boolean includeSubclasses) {
        return this.hasInstances;
    }

    public void init() throws ObjectPersistenceException {
    }

    public boolean isInitialized() {
        return true;
    }

    public String name() {
        return null;
    }

    public void reset() {
        this.instanceCount = 0;
        this.actions.removeAllElements();
    }

    public void resolveImmediately(NakedObject object) {
    }

    public void resolveField(NakedObject object, NakedObjectField field) throws ObjectPersistenceException {
    }

    public void setupInstancesCount(int i) {
        this.instanceCount = i;
    }

    public void setupInstances(NakedObject[] instances, NakedObjectSpecification cls) {
        this.instances = instances;
        this.expectedClass = cls;
    }

    public void setupHasInstances(boolean flag) {
        this.hasInstances = flag;
    }

    public void shutdown() throws ObjectPersistenceException {
    }

    public void startTransaction() {
        this.actions.addElement("startTransaction");
    }

    public NakedObject[] getInstances(InstancesCriteria criteria) throws ObjectPersistenceException, UnsupportedFindException {
        this.actions.addElement("getInstances " + criteria);
        return this.instances;
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        this.actions.addElement("createObject " + object);
        return new CreateObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
            }

            public String toString() {
                return "CreateObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return null;
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        this.actions.addElement("destroyObject " + object);
        return new DestroyObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
            }

            public String toString() {
                return "DestroyObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return object;
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(NakedObject object) {
        this.actions.addElement("saveObject " + object);
        return null;
    }

    public void execute(PersistenceCommand[] commands) throws ObjectPersistenceException {
        for (int i = 0; i < commands.length; ++i) {
            this.actions.addElement("run " + commands[i]);
            commands[i].execute(null);
        }
    }

    public boolean flush(PersistenceCommand[] commands) {
        for (int i = 0; i < commands.length; ++i) {
            this.actions.addElement("flush " + commands[i]);
            commands[i].execute(null);
        }
        return commands.length > 0;
    }

    public void registerService(String name, Oid oid) {
    }
}

