/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.nof.core.persist.TransactionException;
import org.nakedobjects.nof.persist.objectstore.MockObjectStore;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.objectstore.ObjectStoreTransaction;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.ExecutionContext;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;
import org.nakedobjects.nof.persist.transaction.Transaction;
import org.nakedobjects.nof.testsystem.TestProxySystem;

public class TransactionTest
extends TestCase {
    NakedObject object1;
    NakedObject object2;
    MockObjectStore os;
    private Transaction t;

    public static void main(String[] args) {
        TestRunner.run(TransactionTest.class);
    }

    private CreateObjectCommand createCreateCommand(final NakedObject object, final String name) {
        return new CreateObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    private DestroyObjectCommand createDestroyCommand(final NakedObject object, final String name) {
        return new DestroyObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    private SaveObjectCommand createSaveCommand(final NakedObject object, final String name) {
        return new SaveObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    private SaveObjectCommand createCommandThatAborts(final NakedObject object, final String name) {
        return new SaveObjectCommand(){

            public void execute(ExecutionContext context) throws ObjectPersistenceException {
                throw new ObjectPersistenceException();
            }

            public NakedObject onObject() {
                return object;
            }

            public String toString() {
                return name;
            }
        };
    }

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        TestProxySystem system = new TestProxySystem();
        system.init();
        this.os = new MockObjectStore();
        this.t = new ObjectStoreTransaction((NakedObjectStore)this.os);
        this.object1 = system.createTransientTestObject();
        this.object2 = system.createTransientTestObject();
    }

    public void testAbort() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object2, "command 2"));
        this.t.abort();
        TransactionTest.assertEquals((int)0, (int)this.os.getActions().size());
    }

    public void testAbortBeforeCommand() throws Exception {
        this.t.abort();
        TransactionTest.assertEquals((int)0, (int)this.os.getActions().size());
    }

    public void testCommandThrowsAnExceptionCausingAbort() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 1"));
        this.t.addCommand((PersistenceCommand)this.createCommandThatAborts(this.object2, "command 2"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 3"));
        try {
            this.t.commit();
            TransactionTest.fail();
        }
        catch (ObjectPersistenceException objectPersistenceException) {
            // empty catch block
        }
        this.os.assertAction(0, "endTransaction");
        this.os.assertAction(1, "run command 1");
        this.os.assertAction(2, "run command 2");
    }

    public void testAddCommands() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "command 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object2, "command 2"));
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        this.os.assertAction(1, "run command 1");
        this.os.assertAction(2, "run command 2");
        TransactionTest.assertEquals((int)3, (int)this.os.getActions().size());
    }

    public void testAddCreateCommandsButIgnoreSaveForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createCreateCommand(this.object1, "create object 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "save object 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object2, "save object 2"));
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        this.os.assertAction(1, "run create object 1");
        this.os.assertAction(2, "run save object 2");
        TransactionTest.assertEquals((int)3, (int)this.os.getActions().size());
    }

    public void testAddDestoryCommandsButRemovePreviousSaveForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "save object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        this.os.assertAction(1, "run destroy object 1");
        TransactionTest.assertEquals((int)2, (int)this.os.getActions().size());
    }

    public void testIgnoreBothCreateAndDestroyCommandsWhenForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createCreateCommand(this.object1, "create object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object2, "destroy object 2"));
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        this.os.assertAction(1, "run destroy object 2");
        TransactionTest.assertEquals((int)2, (int)this.os.getActions().size());
    }

    public void testIgnoreSaveAfterDeleteForSameObject() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.addCommand((PersistenceCommand)this.createSaveCommand(this.object1, "save object 1"));
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        this.os.assertAction(1, "run destroy object 1");
        TransactionTest.assertEquals((int)2, (int)this.os.getActions().size());
    }

    public void testNoCommands() throws Exception {
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        TransactionTest.assertEquals((int)1, (int)this.os.getActions().size());
    }

    public void testNoTransactionsWhenCommandCancelEachOtherOut() throws Exception {
        this.t.addCommand((PersistenceCommand)this.createCreateCommand(this.object1, "create object 1"));
        this.t.addCommand((PersistenceCommand)this.createDestroyCommand(this.object1, "destroy object 1"));
        this.t.commit();
        this.os.assertAction(0, "endTransaction");
        TransactionTest.assertEquals((int)1, (int)this.os.getActions().size());
    }

    public void testTransactionAlreadyCompleteAfterAbort() throws Exception {
        this.t.abort();
        try {
            this.t.abort();
            TransactionTest.fail();
        }
        catch (TransactionException expected) {
            // empty catch block
        }
        try {
            this.t.commit();
            TransactionTest.fail();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }

    public void testTransactionAlreadyCompleteAfterCommit() throws Exception {
        this.t.commit();
        try {
            this.t.abort();
            TransactionTest.fail();
        }
        catch (TransactionException expected) {
            // empty catch block
        }
        try {
            this.t.commit();
            TransactionTest.fail();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }
}

