/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore.inmemory;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.ObjectNotFoundException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AllInstances;
import org.nakedobjects.nof.core.persist.TitleCriteria;
import org.nakedobjects.nof.persist.objectstore.inmemory.MemoryObjectStore;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;
import org.nakedobjects.nof.testsystem.ProxyTestCase;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;

public class MemoryObjectStoreTest
extends ProxyTestCase {
    private MemoryObjectStore store;

    protected void setUp() throws Exception {
        super.setUp();
        this.store = new MemoryObjectStore();
        this.store.init();
    }

    protected void tearDown() throws Exception {
        this.store.shutdown();
        super.tearDown();
    }

    public void testObjectNotPersistedWhenCreated() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        NakedObjectSpecification specification = object.getSpecification();
        MemoryObjectStoreTest.assertEquals((boolean)false, (boolean)this.store.hasInstances(specification, false));
        MemoryObjectStoreTest.assertEquals((int)0, (int)this.store.getInstances((InstancesCriteria)new AllInstances(specification, false)).length);
        try {
            this.store.getObject(object.getOid(), specification);
            MemoryObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testRetrievedInstanceAdapterIsIsolatedFromOriginal() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject[] retrievedInstance = this.store.getInstances((InstancesCriteria)new AllInstances(specification, false));
        MemoryObjectStoreTest.assertEquals((int)1, (int)retrievedInstance.length);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedInstance[0]);
        MemoryObjectStoreTest.assertSame((Object)object.getObject(), (Object)retrievedInstance[0].getObject());
    }

    public void testRetrievedObjectAdapterIsIsolatedFromOriginal() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject retrievedObject = this.store.getObject(object.getOid(), specification);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedObject);
        MemoryObjectStoreTest.assertEquals((Object)object.getObject(), (Object)retrievedObject.getObject());
    }

    public void testResetClearsAdapterFromLoader() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        MemoryObjectStoreTest.assertNull((Object)NakedObjectsContext.getObjectLoader().getAdapterFor(object.getObject()));
    }

    public void testHasInstances() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        NakedObjectSpecification specification = object.getSpecification();
        MemoryObjectStoreTest.assertEquals((boolean)true, (boolean)this.store.hasInstances(specification, false));
    }

    public void testRetrievedInstancesByTitle() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        object.setupTitleString("title string");
        this.addObjectToStore(object);
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject[] retrievedInstance = this.store.getInstances((InstancesCriteria)new TitleCriteria(specification, "le STR", false));
        MemoryObjectStoreTest.assertEquals((int)1, (int)retrievedInstance.length);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedInstance[0]);
        MemoryObjectStoreTest.assertSame((Object)object.getObject(), (Object)retrievedInstance[0].getObject());
    }

    public void testOidForService() throws Exception {
        TestProxyOid oid = new TestProxyOid(14);
        this.store.registerService("service name", (Oid)oid);
        this.reset();
        Oid oidForService = this.store.getOidForService("service name");
        MemoryObjectStoreTest.assertEquals((Object)oid, (Object)oidForService);
    }

    private void reset() {
        this.store.reset();
        NakedObjectsContext.getObjectLoader().reset();
    }

    public void testCantRegisterServiceMoreThanOnce() throws Exception {
        TestProxyOid oid = new TestProxyOid(14);
        this.store.registerService("service name", (Oid)oid);
        oid = new TestProxyOid(15);
        try {
            this.store.registerService("service name", (Oid)oid);
            MemoryObjectStoreTest.fail();
        }
        catch (NakedObjectRuntimeException nakedObjectRuntimeException) {
            // empty catch block
        }
    }

    public void testRemoveInstance() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        DestroyObjectCommand command = this.store.createDestroyObjectCommand((NakedObject)object);
        MemoryObjectStoreTest.assertEquals((Object)object, (Object)command.onObject());
        this.store.execute(new PersistenceCommand[]{command});
        this.reset();
        NakedObjectSpecification specification = object.getSpecification();
        MemoryObjectStoreTest.assertEquals((boolean)false, (boolean)this.store.hasInstances(specification, false));
    }

    public void testSaveInstance() throws Exception {
        TestProxyNakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject[] retrievedInstance = this.store.getInstances((InstancesCriteria)new TitleCriteria(specification, "changed", false));
        MemoryObjectStoreTest.assertEquals((int)0, (int)retrievedInstance.length);
        object.setupTitleString("changed title");
        SaveObjectCommand command = this.store.createSaveObjectCommand((NakedObject)object);
        MemoryObjectStoreTest.assertEquals((Object)object, (Object)command.onObject());
        this.store.execute(new PersistenceCommand[]{command});
        this.reset();
        retrievedInstance = this.store.getInstances((InstancesCriteria)new TitleCriteria(specification, "changed", false));
        MemoryObjectStoreTest.assertEquals((int)1, (int)retrievedInstance.length);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedInstance[0]);
    }

    private void addObjectToStore(TestProxyNakedObject object) {
        CreateObjectCommand command = this.store.createCreateObjectCommand((NakedObject)object);
        MemoryObjectStoreTest.assertEquals((Object)object, (Object)command.onObject());
        this.store.execute(new PersistenceCommand[]{command});
        this.reset();
    }
}

