/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nof.persist.PersistAlgorithm;
import org.nakedobjects.nof.persist.PersistedObjectAdder;

public class TwoPassPersistAlgorithm
implements PersistAlgorithm {
    private static final Logger LOG = Logger.getLogger(TwoPassPersistAlgorithm.class);

    public void init() {
    }

    public void makePersistent(NakedObject object, PersistedObjectAdder persistor) {
        NakedObjectField field;
        int i;
        if (object.getResolveState().isPersistent() || object.persistable() == Persistable.TRANSIENT) {
            return;
        }
        LOG.info((Object)("persist " + object));
        object.getSpecification().lifecycleEvent(object, 1);
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)object);
        NakedObjectField[] fields = object.getSpecification().getFields();
        for (i = 0; i < fields.length; ++i) {
            Naked fieldValue;
            field = fields[i];
            if (!field.isPersisted() || field.isValue() || field.isCollection() || (fieldValue = field.get(object)) == null) continue;
            if (!(fieldValue instanceof NakedObject)) {
                throw new NakedObjectRuntimeException();
            }
            this.makePersistent((NakedObject)fieldValue, persistor);
        }
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            if (field.isPersisted() || field.isValue() || !(field instanceof OneToManyAssociation)) continue;
            NakedCollection collection = (NakedCollection)field.get(object);
            if (collection == null) {
                throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullName());
            }
            this.makePersistent(collection, persistor);
            Enumeration elements = collection.elements();
            while (elements.hasMoreElements()) {
                this.makePersistent((NakedObject)elements.nextElement(), persistor);
            }
        }
        persistor.addPersistedObject(object);
        object.getSpecification().lifecycleEvent(object, 2);
    }

    private void makePersistent(NakedCollection collection, PersistedObjectAdder persistor) {
        if (collection.getResolveState().isPersistent() || collection.persistable() == Persistable.TRANSIENT) {
            return;
        }
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        NakedObjectsContext.getObjectLoader().madePersistent((NakedReference)collection);
        Enumeration elements = collection.elements();
        while (elements.hasMoreElements()) {
            this.makePersistent((NakedObject)elements.nextElement(), persistor);
        }
    }

    public String name() {
        return "Two pass,  bottom up persistence walker";
    }

    public void shutdown() {
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

