/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NotPersistableException;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AbstractObjectPersistor;
import org.nakedobjects.nof.core.persist.TransactionException;
import org.nakedobjects.nof.core.service.ServiceUtil;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nof.persist.PersistAlgorithm;
import org.nakedobjects.nof.persist.PersistedObjectAdder;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.objectstore.ObjectStoreTransaction;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.Transaction;

public class ObjectStorePersistor
extends AbstractObjectPersistor
implements PersistedObjectAdder {
    private static final Logger LOG = Logger.getLogger(ObjectStorePersistor.class);
    private boolean checkObjectsForDirtyFlag;
    private NakedObjectStore objectStore;
    private Transaction transaction;
    private int transactionLevel;
    private PersistAlgorithm persistAlgorithm;
    private Object[] services;

    public ObjectStorePersistor() {
        LOG.debug((Object)("creating " + this));
    }

    public void abortTransaction() {
        if (this.transaction != null) {
            this.transaction.abort();
            this.transaction = null;
            this.transactionLevel = 0;
            this.objectStore.abortTransaction();
        }
    }

    public void addPersistedObject(NakedObject object) {
        this.getTransaction().addCommand(this.objectStore.createCreateObjectCommand(object));
    }

    public void destroyObject(NakedObject object) {
        LOG.info((Object)("destroyObject " + object));
        object.getSpecification().lifecycleEvent(object, 7);
        DestroyObjectCommand command = this.objectStore.createDestroyObjectCommand(object);
        this.getTransaction().addCommand(command);
        object.getSpecification().lifecycleEvent(object, 8);
    }

    private NakedObjectLoader loader() {
        return NakedObjectsContext.getObjectLoader();
    }

    public void endTransaction() {
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            this.saveChanges();
            this.getTransaction().commit();
            this.transaction = null;
        } else if (this.transactionLevel < 0) {
            this.transactionLevel = 0;
            throw new TransactionException("No transaction running to end");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)"finalizing object manager");
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendTitle("Persistor");
        debug.appendln("Check dirty flag", this.checkObjectsForDirtyFlag);
        debug.appendln("Transaction", (Object)this.transaction);
        debug.appendln("Persist Algorithm", (Object)this.persistAlgorithm);
        debug.appendln("Object Store", (Object)this.objectStore);
        debug.appendln();
        this.objectStore.debugData(debug);
    }

    public String debugTitle() {
        return "Object Store Persistor";
    }

    protected NakedObject[] getInstances(InstancesCriteria criteria) {
        LOG.info((Object)("getInstances matching " + criteria));
        NakedObject[] instances = this.objectStore.getInstances(criteria);
        this.clearChanges();
        return instances;
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification specification) {
        Assert.assertNotNull((String)"needs an OID", (Object)oid);
        Assert.assertNotNull((String)"needs a specification", (Object)specification);
        NakedObject object = NakedObjectsContext.getObjectLoader().isIdentityKnown(oid) ? NakedObjectsContext.getObjectLoader().getAdapterFor(oid) : this.objectStore.getObject(oid, specification);
        return object;
    }

    public Oid getOidForService(String name) {
        return this.objectStore.getOidForService(name);
    }

    private Transaction getTransaction() {
        if (this.transaction == null) {
            return new ObjectStoreTransaction(this.objectStore);
        }
        return this.transaction;
    }

    public boolean hasInstances(NakedObjectSpecification specification, boolean includeSubclasses) {
        LOG.info((Object)("hasInstances of " + specification.getShortName()));
        return this.objectStore.hasInstances(specification, includeSubclasses);
    }

    public boolean isInitialized() {
        return this.objectStore.isInitialized();
    }

    public void init() {
        LOG.debug((Object)("initialising " + this));
        Assert.assertNotNull((String)"persist algorithm required", (Object)this.persistAlgorithm);
        Assert.assertNotNull((String)"object store required", (Object)this.objectStore);
        this.objectStore.init();
        this.persistAlgorithm.init();
        super.init();
        this.setUpRegisterServices();
    }

    private void setUpRegisterServices() {
        NakedObjectReflector reflector = NakedObjectsContext.getReflector();
        NakedObjectLoader loader = NakedObjectsContext.getObjectLoader();
        this.startTransaction();
        for (int i = 0; i < this.services.length; ++i) {
            reflector.installServiceSpecification(this.services[i].getClass());
            Oid oid = this.getOidForService(ServiceUtil.id((Object)this.services[i]));
            if (oid != null) continue;
            NakedObject adapter = loader.createAdapterForTransient(this.services[i], false);
            loader.madePersistent((NakedReference)adapter);
            oid = adapter.getOid();
            this.registerService(ServiceUtil.id((Object)this.services[i]), oid);
        }
        this.endTransaction();
    }

    private boolean isPersistent(NakedReference object) {
        return object.getResolveState().isPersistent();
    }

    public void makePersistent(NakedObject object) {
        if (this.isPersistent((NakedReference)object)) {
            throw new NotPersistableException("Object already persistent: " + object);
        }
        if (object.persistable() == Persistable.TRANSIENT) {
            throw new NotPersistableException("Object must be kept transient: " + object);
        }
        NakedObjectSpecification specification = object.getSpecification();
        if (Features.isService((NakedObjectSpecification)specification)) {
            throw new NotPersistableException("Cannot persist services: " + object);
        }
        this.persistAlgorithm.makePersistent(object, this);
    }

    private void registerService(String name, Oid oid) {
        this.objectStore.registerService(name, oid);
    }

    public void objectChanged(NakedObject object) {
        ResolveState resolveState = object.getResolveState();
        if (resolveState.respondToChangesInPersistentObjects()) {
            NakedObjectSpecification specification = object.getSpecification();
            if (Features.isAlwaysImmutable((NakedObjectSpecification)specification) || Features.isImmutableOncePersisted((NakedObjectSpecification)specification) && resolveState.isPersistent()) {
                throw new ObjectPersistenceException("cannot change immutable object");
            }
            object.getSpecification().lifecycleEvent(object, 3);
            this.getTransaction().addCommand(this.objectStore.createSaveObjectCommand(object));
            object.getSpecification().lifecycleEvent(object, 4);
            NakedObjectsContext.getUpdateNotifer().addChangedObject(object);
        }
        if (resolveState.respondToChangesInPersistentObjects() || resolveState.isTransient()) {
            object.fireChangedEvent();
            NakedObjectsContext.getUpdateNotifer().addChangedObject(object);
        }
    }

    public void reset() {
        this.objectStore.reset();
    }

    public void resolveField(NakedObject object, NakedObjectField field) {
        if (field.isValue()) {
            return;
        }
        NakedReference reference = (NakedReference)field.get(object);
        if (reference == null || reference.getResolveState().isResolved()) {
            return;
        }
        if (!reference.getResolveState().isPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("resolve field " + object.getSpecification().getShortName() + "." + field.getId() + ": " + reference.getSpecification().getShortName() + " " + reference.getResolveState().code() + " " + reference.getOid()));
        }
        this.objectStore.resolveField(object, field);
    }

    public void reload(NakedObject object) {
    }

    public void resolveImmediately(NakedObject object) {
        ResolveState resolveState = object.getResolveState();
        if (resolveState.isResolvable(ResolveState.RESOLVING)) {
            Assert.assertFalse((String)"only resolve object that is not yet resolved", (Object)object, (boolean)object.getResolveState().isResolved());
            Assert.assertTrue((String)"only resolve object that is persistent", (Object)object, (boolean)object.getResolveState().isPersistent());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("resolve immediately: " + object.getSpecification().getShortName() + " " + object.getResolveState().code() + " " + object.getOid()));
            }
            object.getSpecification().lifecycleEvent(object, 5);
            this.objectStore.resolveImmediately(object);
            object.getSpecification().lifecycleEvent(object, 6);
        }
    }

    public void saveChanges() {
        this.collateChanges();
    }

    private synchronized void collateChanges() {
        if (this.checkObjectsForDirtyFlag) {
            LOG.debug((Object)"collating changed objects");
            Enumeration e = this.loader().getIdentifiedObjects();
            while (e.hasMoreElements()) {
                NakedObject object;
                Object o = e.nextElement();
                if (!(o instanceof NakedObject) || !(object = (NakedObject)o).getSpecification().isDirty(object)) continue;
                LOG.debug((Object)("  found dirty object " + object));
                this.objectChanged(object);
                object.getSpecification().clearDirty(object);
            }
        }
    }

    private synchronized void clearChanges() {
        if (this.checkObjectsForDirtyFlag) {
            LOG.debug((Object)"clearing changed objects");
            Enumeration e = this.loader().getIdentifiedObjects();
            while (e.hasMoreElements()) {
                NakedObject object;
                Object o = e.nextElement();
                if (!(o instanceof NakedObject) || !(object = (NakedObject)o).getSpecification().isDirty(object)) continue;
                LOG.debug((Object)("  found dirty object " + object));
                object.getSpecification().clearDirty(object);
            }
        }
    }

    public void set_CheckObjectsForDirtyFlag(boolean checkObjectsForDirtyFlag) {
        this.checkObjectsForDirtyFlag = checkObjectsForDirtyFlag;
    }

    public void set_ObjectStore(NakedObjectStore objectStore) {
        this.setObjectStore(objectStore);
    }

    public void setCheckObjectsForDirtyFlag(boolean checkObjectsForDirtyFlag) {
        this.checkObjectsForDirtyFlag = checkObjectsForDirtyFlag;
    }

    public void setObjectStore(NakedObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public void shutdown() {
        LOG.info((Object)("shutting down " + this));
        super.shutdown();
        if (this.transaction != null) {
            try {
                this.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error((Object)"failure during abort", (Throwable)e2);
            }
        }
        this.persistAlgorithm.shutdown();
        this.objectStore.shutdown();
        this.objectStore = null;
    }

    public void startTransaction() {
        if (this.transaction == null) {
            this.transaction = new ObjectStoreTransaction(this.objectStore);
            this.transactionLevel = 0;
            this.objectStore.startTransaction();
        }
        ++this.transactionLevel;
    }

    public boolean flushTransaction() {
        if (this.transaction != null) {
            this.saveChanges();
            return this.transaction.flush();
        }
        return false;
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        if (this.objectStore != null) {
            toString.append("objectStore", this.objectStore.name());
        }
        if (this.persistAlgorithm != null) {
            toString.append("persistAlgorithm", this.persistAlgorithm.name());
        }
        return toString.toString();
    }

    public void set_PersistAlgorithm(PersistAlgorithm persistAlgorithm) {
        this.persistAlgorithm = persistAlgorithm;
    }

    public void setPersistAlgorithm(PersistAlgorithm persistAlgorithm) {
        this.persistAlgorithm = persistAlgorithm;
    }

    public void setServices(Object[] services) {
        this.services = services;
    }
}

