/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.nof.core.persist.TransactionException;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nof.persist.objectstore.NakedObjectStore;
import org.nakedobjects.nof.persist.transaction.CreateObjectCommand;
import org.nakedobjects.nof.persist.transaction.DestroyObjectCommand;
import org.nakedobjects.nof.persist.transaction.PersistenceCommand;
import org.nakedobjects.nof.persist.transaction.SaveObjectCommand;
import org.nakedobjects.nof.persist.transaction.Transaction;

public class ObjectStoreTransaction
implements Transaction {
    private static final Logger LOG = Logger.getLogger(ObjectStoreTransaction.class);
    private final Vector commands = new Vector();
    private boolean complete;
    private final NakedObjectStore objectStore;
    private final Vector toNotify = new Vector();

    public ObjectStoreTransaction(NakedObjectStore objectStore) {
        this.objectStore = objectStore;
        LOG.debug((Object)("new transaction " + this));
    }

    public void abort() {
        LOG.info((Object)("abort transaction " + this));
        if (this.complete) {
            throw new TransactionException("Transaction already complete; cannot abort");
        }
        this.complete = true;
    }

    public void addCommand(PersistenceCommand command) {
        if (command == null) {
            return;
        }
        NakedObject onObject = command.onObject();
        if (command instanceof SaveObjectCommand) {
            if (this.alreadyHasCreate(onObject) || this.alreadyHasSave(onObject)) {
                LOG.debug((Object)("ignored command as object already created/saved" + command));
                return;
            }
            if (this.alreadyHasDestroy(onObject)) {
                LOG.info((Object)("ignored command " + command + " as object no longer exists"));
                return;
            }
        }
        if (command instanceof DestroyObjectCommand) {
            if (this.alreadyHasCreate(onObject)) {
                this.removeCreate(onObject);
                LOG.info((Object)("ignored both create and destroy command " + command));
                return;
            }
            if (this.alreadyHasSave(onObject)) {
                this.removeSave(onObject);
                LOG.info((Object)("removed prior save command " + command));
            }
        }
        LOG.debug((Object)("add command " + command));
        this.commands.addElement(command);
    }

    void addNotify(NakedObject object) {
        LOG.debug((Object)("add notification for " + object));
        this.toNotify.addElement(object);
    }

    private boolean alreadyHasCommand(Class commandClass, NakedObject onObject) {
        return this.getCommand(commandClass, onObject) != null;
    }

    private boolean alreadyHasCreate(NakedObject onObject) {
        return this.alreadyHasCommand(CreateObjectCommand.class, onObject);
    }

    private boolean alreadyHasDestroy(NakedObject onObject) {
        return this.alreadyHasCommand(DestroyObjectCommand.class, onObject);
    }

    private boolean alreadyHasSave(NakedObject onObject) {
        return this.alreadyHasCommand(SaveObjectCommand.class, onObject);
    }

    public void commit() {
        LOG.info((Object)("commit transaction " + this));
        if (this.complete) {
            throw new TransactionException("Transaction already complete; cannot commit");
        }
        this.objectStore.endTransaction();
        Object[] commandsArray = new PersistenceCommand[this.commands.size()];
        this.commands.copyInto(commandsArray);
        if (commandsArray.length > 0) {
            this.objectStore.execute((PersistenceCommand[])commandsArray);
        }
        for (int i = 0; i < commandsArray.length; ++i) {
            Object command = commandsArray[i];
            if (!(command instanceof DestroyObjectCommand)) continue;
            NakedObject onObject = command.onObject();
            onObject.setOptimisticLock(null);
            onObject.changeState(ResolveState.DESTROYED);
        }
        this.complete = true;
    }

    public boolean flush() {
        LOG.info((Object)("flush transaction " + this));
        Object[] commandsArray = new PersistenceCommand[this.commands.size()];
        this.commands.copyInto(commandsArray);
        if (commandsArray.length > 0) {
            this.removeAllCommands();
            return this.objectStore.flush((PersistenceCommand[])commandsArray);
        }
        return false;
    }

    private PersistenceCommand getCommand(Class commandClass, NakedObject onObject) {
        Enumeration e = this.commands.elements();
        while (e.hasMoreElements()) {
            PersistenceCommand command = (PersistenceCommand)e.nextElement();
            if (!command.onObject().equals(onObject) || !commandClass.isAssignableFrom(command.getClass())) continue;
            return command;
        }
        return null;
    }

    private void removeAllCommands() {
        this.commands.removeAllElements();
    }

    private void removeCommand(Class commandClass, NakedObject onObject) {
        PersistenceCommand toDelete = this.getCommand(commandClass, onObject);
        this.commands.removeElement(toDelete);
    }

    private void removeCreate(NakedObject onObject) {
        this.removeCommand(CreateObjectCommand.class, onObject);
    }

    private void removeSave(NakedObject onObject) {
        this.removeCommand(SaveObjectCommand.class, onObject);
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("complete", this.complete);
        str.append("commands", this.commands.size());
        return str.toString();
    }
}

