/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.persist.objectstore.inmemory;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.nof.core.persist.TitleCriteria;

public class MemoryObjectStoreInstances {
    protected final Hashtable objectInstances = new Hashtable();
    protected final Hashtable titleIndex = new Hashtable();
    private NakedObjectLoader objectLoader;

    public MemoryObjectStoreInstances(NakedObjectLoader objectLoader) {
        this.objectLoader = objectLoader;
    }

    public Enumeration elements() {
        Vector<NakedObject> v = new Vector<NakedObject>(this.objectInstances.size());
        Enumeration e = this.objectInstances.keys();
        while (e.hasMoreElements()) {
            Oid oid = (Oid)e.nextElement();
            v.addElement(this.getObject(oid));
        }
        return v.elements();
    }

    public NakedObject getObject(Oid oid) {
        Object pojo = this.objectInstances.get(oid);
        if (pojo == null) {
            return null;
        }
        NakedObject adapter = this.objectLoader.recreateAdapter(oid, pojo);
        return adapter;
    }

    public boolean hasInstances() {
        return this.numberOfInstances() > 0;
    }

    public void instances(InstancesCriteria criteria, Vector instances) {
        if (criteria instanceof TitleCriteria) {
            Enumeration keys = this.titleIndex.keys();
            while (keys.hasMoreElements()) {
                String title = (String)keys.nextElement();
                if (!((TitleCriteria)criteria).matches(title)) continue;
                Oid oid = (Oid)this.titleIndex.get(title);
                instances.add(this.getObject(oid));
            }
            return;
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            NakedObject element = (NakedObject)e.nextElement();
            if (!criteria.matches(element)) continue;
            instances.addElement(element);
        }
    }

    public int numberOfInstances() {
        return this.objectInstances.size();
    }

    public void remove(Oid oid) {
        this.objectInstances.remove(oid);
    }

    public void save(NakedObject object) {
        this.objectInstances.put(object.getOid(), object.getObject());
        this.titleIndex.put(object.titleString().toLowerCase(), object.getOid());
    }

    public void shutdown() {
        this.objectInstances.clear();
        this.titleIndex.clear();
    }
}

