package org.nakedobjects.nos.security.ldap;

import org.nakedobjects.nof.reflect.peer.ReflectionPeerFactory;
import org.nakedobjects.nof.reflect.peer.ReflectionPeerFactoryInstaller;
import org.nakedobjects.nof.reflect.security.AuthorisationManager;
import org.nakedobjects.nof.reflect.security.SecurityPeerFactory;


public class LdapSecurityPeerFactoryInstaller implements ReflectionPeerFactoryInstaller {

    public ReflectionPeerFactory[] createFactories() {
        SecurityPeerFactory factory = new SecurityPeerFactory();
        AuthorisationManager authManager = new LdapAuthorisationManager();
        factory.setAuthorisationManager(authManager);
        return new ReflectionPeerFactory[] {factory};
    }

    public String getName() {
        return "ldap-security";
    }
}
