/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.security.ldap;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.reflect.peer.MemberIdentifier;
import org.nakedobjects.nof.reflect.security.Authorisor;

public class LdapAuthorisor
implements Authorisor {
    private static final Logger LOG = Logger.getLogger(LdapAuthorisor.class);
    private final String ldapProvider = NakedObjectsContext.getConfiguration().getString("nakedobjects.security.ldap.server");
    private final String ldapDn = NakedObjectsContext.getConfiguration().getString("nakedobjects.security.ldap.dn");
    private final String appDn = NakedObjectsContext.getConfiguration().getString("nakedobjects.security.ldap.application.dn");
    private static final String AUTH_LDAPSERVER = "security.ldap.server";
    private static final String AUTH_LDAPDN = "security.ldap.dn";
    private static final String AUTH_LEARN = "security.learn";
    private static final String AUTH_APPDN = "security.ldap.application.dn";
    private final boolean learn = NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.security.learn", false);
    private static final String RW = "RW";

    public void init() {
    }

    private boolean isPermitted(DirContext authContext, String role, MemberIdentifier member, String flag) throws NamingException {
        String cls = member.toIdentityString(0);
        String name = member.toIdentityString(3);
        String parms = member.toIdentityString(4);
        StringBuffer search = new StringBuffer();
        search.append("cn=").append(cls).append(", ").append(this.appDn);
        String filter = "(&(uniquemember={0}) (|(cn={1}) (cn={2}) (cn={3})))";
        Object[] args = new Object[]{role, cls, name, parms};
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = authContext.search(search.toString(), "(&(uniquemember={0}) (|(cn={1}) (cn={2}) (cn={3})))", args, controls);
        while (answer.hasMore()) {
            Attribute flagAttribute;
            SearchResult result = (SearchResult)answer.nextElement();
            String cn = (String)result.getAttributes().get("cn").get(0);
            if (!cn.equals(cls) && !cn.equals(name) && (!cn.equals(parms) || !result.getName().contains(name))) continue;
            if (flag != null && (flagAttribute = result.getAttributes().get("flag")) != null) {
                return flag.equalsIgnoreCase((String)flagAttribute.get(0));
            }
            return true;
        }
        return false;
    }

    private Attributes createCommonAttributes(String cnName, String role, boolean isClass) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("javaContainer");
        objclass.add("groupOfUniqueNames");
        if (isClass) {
            objclass.add("javaObject");
        }
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(cnName);
        BasicAttribute uniqueMember = new BasicAttribute("uniquemember");
        uniqueMember.add(role);
        if (isClass) {
            BasicAttribute javaClass = new BasicAttribute("javaclassname");
            javaClass.add(cnName);
            attrs.put(javaClass);
        }
        attrs.put(objclass);
        attrs.put(cn);
        attrs.put(uniqueMember);
        return attrs;
    }

    private String createClassBindname(String cls) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(cls).append(", ").append(this.appDn);
        return bindName.toString();
    }

    private void bindClass(DirContext authContext, String role, MemberIdentifier member) throws NamingException {
        String cls = member.toIdentityString(0);
        Attributes attrs = this.createCommonAttributes(cls, role, true);
        try {
            authContext.createSubcontext(this.createClassBindname(cls), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private String createNameBindname(String cls, String name) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(name).append(", ");
        bindName.append(this.createClassBindname(cls));
        return bindName.toString();
    }

    private void bindName(DirContext authContext, String role, MemberIdentifier member) throws NamingException {
        String cls = member.toIdentityString(0);
        String name = member.toIdentityString(3);
        Attributes attrs = this.createCommonAttributes(name, role, false);
        try {
            authContext.createSubcontext(this.createNameBindname(cls, name), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private String createParmsBindname(String cls, String name, String parms) {
        StringBuffer bindName = new StringBuffer();
        bindName.append("cn=").append(parms).append(", ");
        bindName.append(this.createNameBindname(cls, name));
        return bindName.toString();
    }

    private void bindParms(DirContext authContext, String role, MemberIdentifier member) throws NamingException {
        String cls = member.toIdentityString(0);
        String name = member.toIdentityString(3);
        String parms = member.toIdentityString(4).replace(",", "\\,");
        if (parms.length() == 0) {
            return;
        }
        Attributes attrs = this.createCommonAttributes(parms, role, false);
        try {
            authContext.createSubcontext(this.createParmsBindname(cls, name, parms), attrs);
        }
        catch (NameAlreadyBoundException e) {
            LOG.debug((Object)e);
        }
    }

    private boolean bindNames(DirContext authContext, String role, MemberIdentifier member) throws NamingException {
        this.bindClass(authContext, role, member);
        this.bindName(authContext, role, member);
        this.bindParms(authContext, role, member);
        return true;
    }

    private boolean isAuthorised(String role, MemberIdentifier member, String flag) {
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapProvider);
        if (this.learn) {
            env.put("java.naming.security.principal", "uid=admin, ou=system");
            env.put("java.naming.security.credentials", "secret");
        }
        InitialDirContext authContext = null;
        try {
            authContext = new InitialDirContext(env);
            if (this.learn) {
                boolean bl = this.bindNames(authContext, role, member);
                return bl;
            }
            boolean bl = this.isPermitted(authContext, role, member, flag);
            return bl;
        }
        catch (AuthenticationException e) {
            throw new NakedObjectRuntimeException("Failed to authorise using LDAP", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            throw new NakedObjectRuntimeException("Failed to authorise using LDAP", (Throwable)e);
        }
        finally {
            try {
                if (authContext != null) {
                    authContext.close();
                }
            }
            catch (NamingException e) {
                throw new NakedObjectRuntimeException("Failed to authorise using LDAP", (Throwable)e);
            }
        }
    }

    public void shutdown() {
    }

    public boolean isUsable(String role, MemberIdentifier member) {
        return this.isAuthorised(role, member, RW);
    }

    public boolean isVisible(String role, MemberIdentifier member) {
        return this.isAuthorised(role, member, null);
    }
}

