package org.nakedobjects.nos.client.dnd;

import java.util.Enumeration;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.drawing.Image;


public interface CollectionContent {

    Enumeration allElements();

    void debugDetails(final DebugString debug);

    NakedObject[] elements();

    NakedCollection getCollection();

    void contentMenuOptions(final UserActionSet options);

    void viewMenuOptions(final UserActionSet options);

    void parseTextEntry(final String entryText);

    void setOrder(final Comparator order);

    void setOrderByField(final NakedObjectField field);

    void setOrderByElement();

    NakedObjectField getFieldSortOrder();

    Image getIconPicture(final int iconHeight);

    boolean getOrderByElement();

    boolean getReverseSortOrder();

    boolean isOptionEnabled();

    Naked[] getOptions();
}

// Copyright (c) Naked Objects Group Ltd.
