package org.nakedobjects.nos.client.dnd;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.drawing.Image;


public interface Content {

    /**
     * Determines if the specified content can be drop on this content.
     */
    Consent canDrop(Content sourceContent);

    /**
     * Allows this content to add menu options to the set of menu options the user will see for this content.
     * 
     * @see #viewMenuOptions(UserActionSet)
     */
    void contentMenuOptions(UserActionSet options);

    void debugDetails(DebugString debug);

    /**
     * Implements the response to the dropping of the specified content onto this content.
     */
    Naked drop(Content sourceContent);

    String getDescription();

    String getHelp();

    /**
     * The name of the icon to use to respresent the object represented by this content.
     */
    String getIconName();

    /**
     * The icon to use to respresent the object represented by this content.
     */
    Image getIconPicture(int iconHeight);

    String getId();

    /**
     * The object represented by this content.
     */
    Naked getNaked();

    Naked[] getOptions();

    /**
     * The specification of the object represented by this content.
     */
    NakedObjectSpecification getSpecification();

    /**
     * Returns true if this content represents a NakedCollection.
     */
    boolean isCollection();

    /**
     * Returns true if this content represents a NakedObject.
     */
    boolean isObject();

    /**
     * Returns true if the object represented by this content can be persisted.
     */
    boolean isPersistable();

    boolean isOptionEnabled();

    /**
     * Returns true if the object represented by this content is transient; has not been persisted yet.
     */
    boolean isTransient();

    /**
     * Returns true if this content represents a NakedValue.
     */
    boolean isValue();

    void parseTextEntry(String entryText);

    String title();

    /**
     * Allows this content to add menu options to the set of menu options the user will see for this view.
     * 
     * @see #contentMenuOptions(UserActionSet)
     */
    void viewMenuOptions(UserActionSet options);

    String windowTitle();
}
// Copyright (c) Naked Objects Group Ltd.
